/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WordDelimiterFilter
extends TokenFilter {
    private final byte[] charTypeTable;
    public static final int LOWER = 1;
    public static final int UPPER = 2;
    public static final int DIGIT = 4;
    public static final int SUBWORD_DELIM = 8;
    public static final int ALPHA = 3;
    public static final int ALPHANUM = 7;
    static byte[] defaultWordDelimTable;
    final int generateWordParts;
    final int generateNumberParts;
    final int catenateWords;
    final int catenateNumbers;
    final int catenateAll;
    final int splitOnCaseChange;
    final int preserveOriginal;
    private ArrayList<Token> queue = new ArrayList(4);
    private int queuePos = 0;
    private ArrayList<Token> tlist = new ArrayList(4);

    public WordDelimiterFilter(TokenStream in, byte[] charTypeTable, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll, int splitOnCaseChange, int preserveOriginal) {
        super(in);
        this.generateWordParts = generateWordParts;
        this.generateNumberParts = generateNumberParts;
        this.catenateWords = catenateWords;
        this.catenateNumbers = catenateNumbers;
        this.catenateAll = catenateAll;
        this.splitOnCaseChange = splitOnCaseChange;
        this.preserveOriginal = preserveOriginal;
        this.charTypeTable = charTypeTable;
    }

    public WordDelimiterFilter(TokenStream in, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll, int splitOnCaseChange, int preserveOriginal) {
        this(in, defaultWordDelimTable, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, splitOnCaseChange, preserveOriginal);
    }

    @Deprecated
    public WordDelimiterFilter(TokenStream in, byte[] charTypeTable, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll) {
        this(in, charTypeTable, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, 1, 0);
    }

    @Deprecated
    public WordDelimiterFilter(TokenStream in, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll) {
        this(in, defaultWordDelimTable, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, 1, 0);
    }

    int charType(int ch) {
        if (ch < this.charTypeTable.length) {
            return this.charTypeTable[ch];
        }
        if (Character.isLowerCase(ch)) {
            return 1;
        }
        if (Character.isLetter(ch)) {
            return 2;
        }
        return 8;
    }

    private int tokType(Token t) {
        return this.charType(t.termBuffer()[0]);
    }

    private Token newTok(Token orig, int start, int end) {
        int startOff = orig.startOffset();
        int endOff = orig.endOffset();
        if (orig.termLength() == endOff - startOff) {
            endOff = startOff + end;
            startOff += start;
        }
        Token newTok = new Token(startOff, endOff, orig.type());
        newTok.setTermBuffer(orig.termBuffer(), start, end - start);
        return newTok;
    }

    public final Token next(Token in) throws IOException {
        Token t;
        if (this.queuePos < this.queue.size()) {
            return this.queue.get(this.queuePos++);
        }
        if (this.queuePos != 0) {
            this.queuePos = 0;
            this.queue.clear();
        }
        int origPosIncrement = 0;
        while (true) {
            boolean isWord;
            if ((t = this.input.next(in)) == null) {
                return null;
            }
            char[] termBuffer = t.termBuffer();
            int len = t.termLength();
            int start = 0;
            if (len == 0) continue;
            origPosIncrement += t.getPositionIncrement();
            char ch = termBuffer[start];
            int type = this.charType(ch);
            int numWords = 0;
            while (start < len) {
                while ((type & 8) != 0 && ++start < len) {
                    ch = termBuffer[start];
                    type = this.charType(ch);
                }
                int pos = start;
                int firstType = type;
                int lastType = type;
                while (pos < len) {
                    if (type != lastType) {
                        if ((lastType & 3) != 0 && ch == '\'' && pos + 1 < len && (termBuffer[pos + 1] == 's' || termBuffer[pos + 1] == 'S')) {
                            int subWordEnd = pos;
                            if (pos + 2 >= len) {
                                pos += 2;
                            } else {
                                char ch2 = termBuffer[pos + 2];
                                int type2 = this.charType(ch2);
                                if ((type2 & 8) != 0) {
                                    ch = ch2;
                                    type = type2;
                                    pos += 2;
                                }
                            }
                            this.queue.add(this.newTok(t, start, subWordEnd));
                            if ((firstType & 3) == 0) break;
                            ++numWords;
                            break;
                        }
                        if (!(this.splitOnCaseChange == 0 && (lastType & 3) != 0 && (type & 3) != 0 || (lastType & 2) != 0 && (type & 1) != 0)) {
                            this.queue.add(this.newTok(t, start, pos));
                            if ((firstType & 3) == 0) break;
                            ++numWords;
                            break;
                        }
                    }
                    if (++pos >= len) {
                        if (start == 0) {
                            return t;
                        }
                        if (this.queue.size() == 0 && this.preserveOriginal == 0) {
                            t.setTermBuffer(termBuffer, start, len - start);
                            return t;
                        }
                        Token newtok = this.newTok(t, start, pos);
                        this.queue.add(newtok);
                        if ((firstType & 3) == 0) break;
                        ++numWords;
                        break;
                    }
                    lastType = type;
                    ch = termBuffer[pos];
                    type = this.charType(ch);
                }
                start = pos;
            }
            int numtok = this.queue.size();
            if (numtok == 0) {
                if (this.preserveOriginal == 0) continue;
                return t;
            }
            if (numtok == 1) break;
            int numNumbers = numtok - numWords;
            if (!(this.catenateAll != 0 || this.catenateWords != 0 && numWords > 1 || this.catenateNumbers != 0 && numNumbers > 1 || this.generateWordParts == 0 && numWords != 0 || this.generateNumberParts == 0 && numNumbers != 0)) break;
            ArrayList<Token> tmp = this.tlist;
            this.tlist = this.queue;
            this.queue = tmp;
            this.queue.clear();
            if (numWords == 0) {
                this.addCombos(this.tlist, 0, numtok, this.generateNumberParts != 0, this.catenateNumbers != 0 || this.catenateAll != 0, 1);
                if (this.queue.size() <= 0 && this.preserveOriginal == 0) continue;
                break;
            }
            if (numNumbers == 0) {
                this.addCombos(this.tlist, 0, numtok, this.generateWordParts != 0, this.catenateWords != 0 || this.catenateAll != 0, 1);
                if (this.queue.size() <= 0 && this.preserveOriginal == 0) continue;
                break;
            }
            if (this.generateNumberParts == 0 && this.generateWordParts == 0 && this.catenateNumbers == 0 && this.catenateWords == 0) {
                this.addCombos(this.tlist, 0, numtok, false, this.catenateAll != 0, 1);
                if (this.queue.size() <= 0 && this.preserveOriginal == 0) continue;
                break;
            }
            Token tok = this.tlist.get(0);
            boolean wasWord = isWord = (this.tokType(tok) & 3) != 0;
            int i = 0;
            while (i < numtok) {
                int j;
                for (j = i + 1; j < numtok; ++j) {
                    wasWord = isWord;
                    tok = this.tlist.get(j);
                    boolean bl = isWord = (this.tokType(tok) & 3) != 0;
                    if (isWord != wasWord) break;
                }
                if (wasWord) {
                    this.addCombos(this.tlist, i, j, this.generateWordParts != 0, this.catenateWords != 0, 1);
                } else {
                    this.addCombos(this.tlist, i, j, this.generateNumberParts != 0, this.catenateNumbers != 0, 1);
                }
                i = j;
            }
            if (this.catenateAll != 0) {
                this.addCombos(this.tlist, 0, numtok, false, true, 0);
            }
            if (this.queue.size() > 0 || this.preserveOriginal != 0) break;
        }
        if (this.preserveOriginal != 0) {
            this.queuePos = 0;
            if (this.queue.size() > 0) {
                this.queue.get(0).setPositionIncrement(0);
            }
            return t;
        }
        this.queuePos = 1;
        Token tok = this.queue.get(0);
        tok.setPositionIncrement(origPosIncrement);
        return tok;
    }

    private void addCombos(List<Token> lst, int start, int end, boolean generateSubwords, boolean catenateSubwords, int posOffset) {
        if (end - start == 1) {
            this.queue.add(lst.get(start));
            return;
        }
        StringBuilder sb = null;
        if (catenateSubwords) {
            sb = new StringBuilder();
        }
        Token firstTok = null;
        Token tok = null;
        for (int i = start; i < end; ++i) {
            tok = lst.get(i);
            if (catenateSubwords) {
                if (i == start) {
                    firstTok = tok;
                }
                sb.append(tok.termBuffer(), 0, tok.termLength());
            }
            if (!generateSubwords) continue;
            this.queue.add(tok);
        }
        if (catenateSubwords) {
            Token concatTok = new Token(sb.toString(), firstTok.startOffset(), tok.endOffset(), firstTok.type());
            concatTok.setPositionIncrement(generateSubwords ? 0 : posOffset);
            this.queue.add(concatTok);
        }
    }

    static {
        byte[] tab = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byte code = 0;
            if (Character.isLowerCase(i)) {
                code = (byte)(code | 1);
            } else if (Character.isUpperCase(i)) {
                code = (byte)(code | 2);
            } else if (Character.isDigit(i)) {
                code = (byte)(code | 4);
            }
            if (code == 0) {
                code = (byte)8;
            }
            tab[i] = code;
        }
        defaultWordDelimTable = tab;
    }
}

