/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.RequestFormViewHandler;
import com.jurismarches.vradi.ui.RequestFormViewUI;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.editors.CurrencyEditor;
import com.jurismarches.vradi.ui.editors.DateEditor;
import com.jurismarches.vradi.ui.editors.DateTimeEditor;
import com.jurismarches.vradi.ui.editors.EmailEditor;
import com.jurismarches.vradi.ui.editors.IdEditor;
import com.jurismarches.vradi.ui.editors.NumEditor;
import com.jurismarches.vradi.ui.editors.StringEditor;
import com.jurismarches.vradi.ui.editors.TextEditor;
import com.jurismarches.vradi.ui.editors.UrlEditor;
import com.jurismarches.vradi.ui.editors.VradiEditor;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class OfferEditHandler {
    private static final Log log = LogFactory.getLog(OfferEditHandler.class);
    private static final String DEFAULT_EDITOR_NAME = "$default";
    public static final String REQUIRED_FIELD_CONTEXT = "required";
    protected static Map<String, Class<? extends VradiEditor<?, ?>>> editorMapping;

    public OfferEditUI initUI(JAXXContext rootContext, Form data) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        context.add((Object)data);
        UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class);
        OfferEditUI ui = new OfferEditUI((JAXXContext)context);
        this.fillfields(ui, data);
        ArrayList editUIs = (ArrayList)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (editUIs == null) {
            editUIs = new ArrayList();
            VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), editUIs);
        }
        ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).add(ui);
        this.initThesaurus((JAXXContext)context, ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is " + ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).size() + " OfferEditUI in referenciel"));
        }
        return ui;
    }

    public void initThesaurus(JAXXContext context, OfferEditUI ui) {
        JPanel thesaurusPanel = ui.getThesaurus();
        thesaurusPanel.removeAll();
        ThesaurusHandler thesaurusHandler = UIHelper.getHandler(context, ThesaurusHandler.class);
        List<String> thesaurusId = VradiHelper.getVradiListThesaurus();
        VradiThesaurusDTO rootThesaurus = null;
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            rootThesaurus = new VradiThesaurusDTO();
            rootThesaurus.fromWikitty(rootTreeNode);
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant get root thesaurus ", (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        Collection thesaurusChildren = rootThesaurus.getChildren();
        ArrayList<VradiThesaurusDTO> thesaurusSaved = new ArrayList<VradiThesaurusDTO>();
        if (thesaurusChildren != null && !thesaurusChildren.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("chidren size : " + thesaurusChildren.size()));
            }
            if (thesaurusId != null) {
                for (String id : thesaurusId) {
                    VradiThesaurusDTO savedThesaurus = rootThesaurus.findThesaurus(id);
                    if (savedThesaurus == null) continue;
                    thesaurusSaved.add(savedThesaurus);
                    for (VradiThesaurusDTO child : thesaurusChildren) {
                        child.removeThesaurusRecursivly(savedThesaurus);
                    }
                }
            }
            for (VradiThesaurusDTO child : thesaurusChildren) {
                thesaurusPanel.add((Component)((Object)thesaurusHandler.initUI(context, child, ui.getData(), false)));
            }
            for (VradiThesaurusDTO saved : thesaurusSaved) {
                thesaurusPanel.add((Component)((Object)thesaurusHandler.initUI(context, saved, ui.getData(), true)));
            }
        }
    }

    protected void fillfields(OfferEditUI ui, Form data) {
        for (WikittyExtension ext : data.getExtensions()) {
            if (ext.equals((Object)ModificationTag.MODIFICATION_TAG)) continue;
            for (String fieldName : ext.getFieldNames()) {
                FieldType type = ext.getFieldType(fieldName);
                this.createField(ui, ext.getName(), fieldName, type, data);
            }
        }
    }

    protected void createField(OfferEditUI ui, String ext, String fieldName, FieldType type, BusinessEntity data) {
        JPanel content = ui.getContent();
        if (!type.isCollection()) {
            VradiEditor editor = null;
            if (ext.equals("Form") && fieldName.equals("id")) {
                editor = new IdEditor((JAXXContext)ui);
                ((IdEditor)editor).getWikittyId().setText(data.getWikittyId());
            } else {
                editor = this.getEditor(type, (JAXXContext)ui);
            }
            if (editor != null) {
                Object value = data.getField(ext, fieldName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("editor data = [" + editor.getObjectById("data") + "] for value[" + value + "]"));
                }
                editor.setFieldName(fieldName);
                editor.setFieldDescription(type.getTagValue("description"));
                editor.setExtensionName(ext);
                editor.setValue(value);
                if (type.isNotNull()) {
                    editor.setValidatorContext(REQUIRED_FIELD_CONTEXT);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(fieldName + " is not null"));
                    }
                }
                content.add((Component)((Object)editor));
            }
        }
    }

    OfferEditUI getUI(JAXXContext context) {
        if (context instanceof OfferEditUI) {
            return (OfferEditUI)context;
        }
        return null;
    }

    public void openRequestPopup(JAXXContext context, List<String> queries) {
        RequestFormViewHandler handler = UIHelper.getHandler(context, RequestFormViewHandler.class);
        RequestFormViewUI ui = handler.initUI(context);
        for (String query : queries) {
            ui.getContent().add((Component)new JLabel(query));
        }
        ui.setVisible(true);
    }

    protected void addPropositions(JAXXContext context, Object[] props) {
        for (Object p : props) {
            this.getUI((JAXXContext)context).propositionListModel.removeElement(p);
        }
    }

    protected void save(JAXXContext context, Form form) {
        VradiUser vradiUser;
        log.info((Object)("Save form " + form.getName()));
        form.clearThesaurus();
        for (Component c : this.getUI(context).getThesaurus().getComponents()) {
            Object[] selected;
            ThesaurusUI thesaurusUI = (ThesaurusUI)((Object)c);
            DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
            for (Object s : selected = model.toArray()) {
                TreeNode treeNode = (TreeNode)s;
                log.debug((Object)treeNode.getChildren());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("treeNode to save : " + treeNode.getName() + " in form : " + form.getName()));
                }
                form.addThesaurus(treeNode.getWikittyId());
            }
        }
        for (Component c : this.getUI(context).getContent().getComponents()) {
            VradiEditor editor = (VradiEditor)((Object)c);
            form.setField(editor.getExtensionName(), editor.getFieldName(), editor.getValue());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("field to save : " + editor.getFieldName() + " = " + editor.getValue() + " in form : " + form.getName()));
        }
        if (!form.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
            form.addExtension(ModificationTag.MODIFICATION_TAG);
        }
        form.setField("ModificationTag", "lastModifier", (vradiUser = (VradiUser)context.getContextValue(VradiUser.class)) != null ? vradiUser.getName() : null);
        form.setField("ModificationTag", "lastModified", new Date());
        try {
            ServiceHelper.getVradiStorageService().updateForm(form);
        }
        catch (TechnicalException eee) {
            log.error((Object)("Cant save form : " + form.getName()), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = (VradiMainUIHandler)VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void test(JAXXContext context, Form form) {
        ArrayList<String> queries = new ArrayList();
        try {
            queries = ServiceHelper.getVradiStorageService().getQueriesReturningForm(form);
        }
        catch (TechnicalException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        this.openRequestPopup(context, queries);
    }

    protected void addFile(JAXXContext context) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.showOpenDialog(this.getUI(context));
        File file = fileChooser.getSelectedFile();
    }

    protected void removeFile(JAXXContext context) {
    }

    public void addThesaurus(JAXXContext context, VradiThesaurusDTO thesToAdd) {
        for (Component c : this.getUI(context).getThesaurus().getComponents()) {
            ThesaurusUI ui = (ThesaurusUI)((Object)c);
            ThesaurusTreeHelper helper = ui.helper;
            NavigationTreeNode rootNode = helper.getRootNode();
            VradiThesaurusDTO root = (VradiThesaurusDTO)rootNode.getBean();
            log.info((Object)("Try to add " + thesToAdd.getName() + " to " + root.getName()));
            if (!root.addChildRecursif(thesToAdd)) continue;
            log.info((Object)"succes");
            helper.setRootThesaurus(root);
            helper.createTreeModel(context);
            ui.getThesaurus().setModel((TreeModel)helper.getTreeModel(context));
            break;
        }
    }

    protected synchronized VradiEditor getEditor(FieldType type, JAXXContext context) {
        String editorName;
        if (editorMapping == null) {
            editorMapping = new TreeMap();
            editorMapping.put(FieldTypeEnum.STRING.name(), StringEditor.class);
            editorMapping.put(FieldTypeEnum.DATE_TIME.name(), DateTimeEditor.class);
            editorMapping.put(FieldTypeEnum.DATE.name(), DateEditor.class);
            editorMapping.put(FieldTypeEnum.EMAIL.name(), EmailEditor.class);
            editorMapping.put(FieldTypeEnum.NUMERIC.name(), NumEditor.class);
            editorMapping.put(FieldTypeEnum.TEXT.name(), TextEditor.class);
            editorMapping.put(FieldTypeEnum.URL.name(), UrlEditor.class);
            editorMapping.put(FieldTypeEnum.CURRENCY.name(), CurrencyEditor.class);
            editorMapping.put(DEFAULT_EDITOR_NAME, StringEditor.class);
        }
        FieldTypeEnum typeEnum = FieldTypeEnum.valueOf(type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("typeEnum of type " + type + " = " + (Object)((Object)typeEnum)));
        }
        String string = editorName = typeEnum == null ? DEFAULT_EDITOR_NAME : typeEnum.name();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor name for type [" + type.getType() + "] : " + editorName));
        }
        Class<VradiEditor<?, ?>> editorClass = editorMapping.get(editorName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor class to use : " + editorClass));
        }
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = editorClass.getConstructors()) {
                if (constructor.getParameterTypes() == null || constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(JAXXContext.class)) continue;
                VradiEditor editor = (VradiEditor)((Object)constructor.newInstance(context));
                editor.init();
                return editor;
            }
            return null;
        }
        catch (InvocationTargetException eee) {
            throw new IllegalStateException(eee);
        }
        catch (InstantiationException eee) {
            throw new IllegalStateException(eee);
        }
        catch (IllegalAccessException eee) {
            throw new IllegalStateException(eee);
        }
    }
}

