/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiAction;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import jaxx.runtime.Util;
import jaxx.runtime.context.DefaultApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

@DefaultApplicationContext.AutoLoad
public class VradiConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(VradiConfig.class);
    public static final String APPLICATION_PROPERTIES = "/vradi.properties";
    public static final String USER_DIRECTORY_FILENAME = ".vradi/vradi-";
    protected static File vradiUserDirectory;
    protected boolean fullscreen;
    private boolean displayMainUI = true;
    private boolean canUseUI = true;
    public static final String[] DEFAULT_JAXX_PCS;

    public File getVradiUserDirectory() {
        if (vradiUserDirectory == null) {
            vradiUserDirectory = new File(new File(VradiConfig.getUserHome()), USER_DIRECTORY_FILENAME + this.getVersion().getVersion());
        }
        return vradiUserDirectory;
    }

    public File getUserFile() {
        if (this.getVersion().getVersion() != null && !this.getVersion().getVersion().isEmpty()) {
            return new File(VradiConfig.getUserHome() + File.separator + USER_DIRECTORY_FILENAME + this.getVersion().getVersion() + File.separator + "." + this.getConfigFileName());
        }
        return null;
    }

    public VradiConfig() {
        this.setConfigFileName(Option.CONFIG_FILE.defaultValue);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(APPLICATION_PROPERTIES);
        Properties p = new Properties();
        try {
            p.load(stream);
            for (Object k : p.keySet()) {
                String key = k + "";
                Object value = p.get(k);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("install properties " + k + " : " + value));
                }
                this.setDefaultOption(key, "" + value);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (Option o : Option.values()) {
            this.setDefaultOption(o.key, o.defaultValue);
        }
        String sVersion = VersionUtil.removeSnapshot((String)this.getOption("application.version"));
        Version version = VersionUtil.valueOf((String)sVersion);
        this.setDefaultOption("version", version.getVersion());
        Version dbVersion = null;
        dbVersion = version.hasClassifier() ? VersionUtil.removeClassifier((Version)version) : VersionUtil.valueOf((String)version.toString());
        this.setDefaultOption("db.version", dbVersion.getVersion());
        FileUtil.setCurrentDirectory((File)this.getVradiUserDirectory());
        this.getVradiUserDirectory().mkdirs();
        this.initActions();
    }

    public void initActions() {
        for (Action a : Action.values()) {
            for (String alias : a.aliases) {
                this.addActionAlias(alias, a.action);
            }
        }
    }

    public String getCopyrightText() {
        return "Version " + this.getVersion() + " JurisMarches @ 2009";
    }

    public Version getVersion() {
        Version option = (Version)this.getOption(Version.class, "version");
        return option;
    }

    public Version getDbVersion() {
        Version option = (Version)this.getOption(Version.class, "db.version");
        return option;
    }

    public boolean isFullScreen() {
        Boolean result = this.getOptionAsBoolean(Option.FULL_SCREEN.key);
        return result != null && result != false;
    }

    public boolean isDisplayMainUI() {
        return this.displayMainUI;
    }

    public boolean isCanUseUI() {
        return this.canUseUI;
    }

    public Locale getLocale() {
        Locale result = (Locale)this.getOption(Locale.class, Option.LOCALE.key);
        return result;
    }

    public void setFullscreen(boolean fullscreen) {
        boolean oldValue = this.isFullScreen();
        this.setOption(Option.FULL_SCREEN.key, fullscreen + "");
        this.saveForUser(new String[0]);
        this.firePropertyChange("fullscreen", oldValue, fullscreen);
    }

    public void setDisplayMainUI(boolean b) {
        this.displayMainUI = b;
    }

    public void setCanUseUI(boolean canUseUI) {
        this.canUseUI = canUseUI;
        if (!canUseUI) {
            this.setDisplayMainUI(false);
        }
    }

    public void setLocale(Locale newLocale) {
        this.setOption(Option.LOCALE.key, newLocale.toString());
        this.saveForUser(new String[0]);
        this.firePropertyChange("locale", null, newLocale);
    }

    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove = Util.findJaxxPropertyChangeListener((String[])DEFAULT_JAXX_PCS, (PropertyChangeListener[])this.getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    static {
        DEFAULT_JAXX_PCS = new String[]{"showNumberEditorButton", "autoPopupNumberEditor", "fullScreen", "locale"};
    }

    public static enum Action {
        HELP(I18n._((String)"vradi.action.commandline.help"), VradiAction.class.getName() + "#help", "-h", "--help"),
        HELP_UI(I18n._((String)"vradi.action.commandline.help.ui"), VradiAction.class.getName() + "#helpUI", "--help-ui"),
        NO_MAIN_UI(I18n._((String)"vradi.action.commandline.disable.main.ui"), VradiAction.class.getName() + "#disableMainUI", "-n", "--no-main"),
        CONFIGURE_UI(I18n._((String)"vradi.action.commandline.configure.ui"), VradiAction.class.getName() + "#configure", "--configure");

        public String description;
        public String action;
        public String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }
    }

    public static enum Step {
        AfterInit,
        BeforeExit;

    }

    public static enum Option implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"vradi.config.configFileName.description"), "vradi-config", String.class, true, true),
        FULL_SCREEN("ui.fullscreen", I18n._((String)"vradi.config.ui.fullscreen"), "false", Boolean.class, false, false),
        LOCALE("ui.locale", I18n._((String)"vradi.config.ui.locale"), Locale.FRANCE.toString(), Locale.class, false, false);

        public final String key;
        public final String description;
        public final String defaultValue;
        public final Class<?> type;
        public final boolean _transient;
        public final boolean _final;

        private Option(String key, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this._final = _final;
            this._transient = _transient;
        }

        public boolean isFinal() {
            return this._final;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

