/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientEmailContentTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ClientEmailContentTableModel.class);
    protected List<VradiSendingDTO> data = new ArrayList<VradiSendingDTO>();
    protected boolean valueIsAdjusting;

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void clear() {
        this.data.clear();
        if (!this.valueIsAdjusting) {
            this.fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public List<VradiSendingDTO> getData() {
        return new ArrayList<VradiSendingDTO>(this.data);
    }

    public void addEntry(VradiSendingDTO formsByClientDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding client " + formsByClientDTO.getClientDTO().getName()));
        }
        this.data.add(formsByClientDTO);
        if (this.isValueIsAdjusting()) {
            int newIndex = this.data.size() - 1;
            this.fireTableRowsInserted(newIndex, newIndex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        VradiSendingDTO value = this.data.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = value.getClientDTO();
                break;
            }
            case 1: {
                result = value.getFormDTOs();
                break;
            }
            case 2: {
                result = value.getParagraph();
                break;
            }
            case 3: {
                result = value.getStatus();
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        VradiSendingDTO value = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                value.setClientDTO((VradiClientDTO)aValue);
                break;
            }
            case 1: {
                value.setFormDTOs((List)aValue);
                break;
            }
            case 2: {
                value.setParagraph((String)aValue);
                break;
            }
            case 3: {
                value.setStatus((String)aValue);
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected void ensureRowIndex(int rowIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("rowIndex (" + rowIndex + ") can not be greater than " + this.getRowCount());
        }
    }

    protected void ensureColumnIndex(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("columnIndex (" + columnIndex + ") can not be greater than " + this.getColumnCount());
        }
    }
}

