/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.ui.CreateOfferDialogUI;
import com.jurismarches.vradi.ui.DateFormTypeFilterHandler;
import com.jurismarches.vradi.ui.DateFormTypeFilterUI;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.VradiCriteriaField;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.VradiTabHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.MouseInputAdapter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;

public class OfferListHandler {
    private static final Log log = LogFactory.getLog(OfferListHandler.class);

    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        DateFormTypeFilterHandler criteriaHandler = new DateFormTypeFilterHandler();
        DateFormTypeFilterUI criteriaUI = criteriaHandler.initUI(rootContext);
        context.add((Object)this);
        context.add((Object)criteriaHandler);
        context.add((Object)criteriaUI);
        OfferListUI ui = new OfferListUI((JAXXContext)context);
        ui.getCriteriaPanel().add((Component)criteriaUI, "Center");
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        return ui;
    }

    public DateFormTypeFilterHandler getCriteriaHandler(JAXXContext context) {
        return (DateFormTypeFilterHandler)context.getContextValue(DateFormTypeFilterHandler.class);
    }

    public OfferListTableModel getOfferListTableModel() {
        List<Object> forms = new ArrayList<Form>();
        GregorianCalendar now = new GregorianCalendar();
        now.set(10, 0);
        now.set(12, 0);
        now.set(14, 0);
        try {
            forms = ServiceHelper.getVradiStorageService().findForms(null, null, null, now.getTime(), now.getTime(), null);
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant find forms for this day ", (Throwable)eee);
        }
        OfferListTableModel model = new OfferListTableModel(forms, true);
        return model;
    }

    public void addEditPane(JAXXContext context, Form data) {
        OfferListUI ui = this.getUI(context);
        ui.setDividerLocation(350);
        ui.setResizeWeight(0.65);
        ui.setDividerSize(10);
        JTabbedPane contentTabbedPane = ui.getEditTabs();
        String id = data.getWikittyId();
        if (contentTabbedPane.indexOfTab(id) < 0) {
            OfferEditHandler handler = new OfferEditHandler();
            OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);
            VradiTabHeader panel = new VradiTabHeader();
            panel.getLabel().setText(data.getName());
            panel.setId(id);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), (Component)((Object)panel));
            panel.getCloseTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.closePane(e);
                }
            });
            panel.getDetachTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.detachPane(e);
                }
            });
        }
        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        return (VradiTabHeader)((Object)button.getParent());
    }

    protected void closePane(MouseEvent e) {
        VradiTabHeader mytab = this.getTabHeader(e);
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        String id = mytab.getId();
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        contentTabbedPane.remove(contentTabbedPane.indexOfTab(id));
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected void detachPane(MouseEvent e) {
        VradiTabHeader mytab = this.getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        OfferEditUI content = (OfferEditUI)contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
        final JFrame frame = new JFrame(name);
        content.getValidate().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        content.getAnnuler().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)content, "Center");
        frame.setVisible(true);
        frame.pack();
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            this.addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1.0);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI)context;
        }
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = this.getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context) {
        this.edit(context, this.getUI((JAXXContext)context).listTable.getSelectedRow(), this.getUI((JAXXContext)context).offerListTableModel);
    }

    protected void edit(JAXXContext context, int i, OfferListTableModel model) {
        Form data = null;
        data = i == 0 ? this.createForm(context) : model.getDatas().get(i - 1);
        log.debug((Object)("Form selected : " + data));
        if (data != null) {
            this.addEditPane(context, data);
        }
    }

    public Form createForm(JAXXContext context) {
        List extensions = null;
        try {
            extensions = ServiceHelper.getVradiStorageService().getAllFormTypes();
        }
        catch (TechnicalException ex) {
            log.error((Object)"Cant get all formTypes caused by : ", (Throwable)ex);
        }
        CreateOfferDialogUI dialog = new CreateOfferDialogUI(context);
        dialog.setVisible(true);
        log.debug((Object)dialog.isOk());
        log.debug((Object)dialog.getNameValue());
        log.debug((Object)dialog.getFormType());
        if (dialog.isOk().booleanValue()) {
            String name = dialog.getNameValue();
            WikittyExtension ext = dialog.getFormType();
            log.debug((Object)("FormType selected : " + ext));
            if (ext == null) {
                return null;
            }
            FormImpl form = new FormImpl();
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
            Wikitty wikitty = entityWikitty.getWikitty();
            wikitty.addExtension(ext);
            form = (Form)entityWikitty;
            if (name != null && !name.isEmpty()) {
                form.setName(name);
            } else {
                form.setName(I18n._((String)"vradi.forms.new.defaultName"));
            }
            return form;
        }
        return null;
    }

    public ComboBoxModel getRequestModel() {
        return new DefaultComboBoxModel();
    }

    public void executeQuery(OfferListUI ui) {
        List<Form> forms;
        String query = ui.getRequest().getText().trim();
        if (ui.isAdvencedSearchCollapsed().booleanValue()) {
            forms = VradiHelper.executeQuery(query, null, null, null, null, null);
        } else {
            DateFormTypeFilterUI criterias = this.getCriteriaHandler((JAXXContext)ui).getUI((JAXXContext)ui);
            Component[] thesaurusCriteria = criterias.getCriterias().getComponents();
            ArrayList[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; ++i) {
                Thesaurus th = (Thesaurus)((VradiCriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (th == null) continue;
                thesaurus[i] = new ArrayList();
                thesaurus[i].add(th.getWikittyId());
                VradiHelper.getThesaurusChildren(th, thesaurus[i]);
            }
            forms = VradiHelper.executeQuery(query, (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem(), (String)criterias.getDateTypeSelection().getSelectedItem(), criterias.getFromDate().getDate(), criterias.getToDate().getDate(), thesaurus);
        }
        log.debug((Object)forms.size());
        this.addRequestToProperties(query);
        ((DefaultComboBoxModel)ui.getRequests().getModel()).removeElement(query);
        ui.getRequests().insertItemAt(query, 0);
        ui.getRequests().setSelectedIndex(0);
        ui.getOfferListTableModel().setDatas(forms);
    }

    public void addRequestToProperties(String request) {
        VradiHelper.addRequestToProperties(request);
    }

    public List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public void removeColumn(JAXXContext context, TreeNode thesaurus) {
        VradiHelper.removeVradiListColumns(thesaurus);
        this.getUI(context).updateTableModel();
    }
}

