/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.MD5;
import org.nuiton.util.MD5OutputStream;

public class ZipUtil {
    private static Log log = LogFactory.getLog(ZipUtil.class);
    private static final int BUFFER_SIZE = 8192;
    private static final String LOCAL_SEP = File.separator;
    private static final String LOCAL_SEP_PATTERN = "\\".equals(LOCAL_SEP) ? LOCAL_SEP + LOCAL_SEP : LOCAL_SEP;
    private static final String ZIP_SEP = "/";
    private static final String ZIP_SEP_PATTERN = "/";
    protected static FileFilter ALL_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    };

    public static String uncompress(File file, File targetDir) throws IOException {
        String result = ZipUtil.uncompressAndRename(file, targetDir, null, null);
        return result;
    }

    public static String uncompressAndRename(File file, File targetDir, String renameFrom, String renameTo) throws IOException {
        ZipEntry entry;
        String result = "";
        ZipInputStream in = new ZipInputStream(new FileInputStream(file));
        while ((entry = in.getNextEntry()) != null) {
            int len;
            String name = entry.getName();
            if (renameFrom != null && renameTo != null) {
                name = name.replaceAll(renameFrom, renameTo);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("rename " + entry.getName() + " -> " + name));
                }
            }
            result = name;
            File target = new File(targetDir, name);
            if (entry.isDirectory()) {
                target.mkdirs();
                continue;
            }
            target.getParentFile().mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).close();
        }
        in.close();
        return result;
    }

    public static void compressFiles(File zipFile, File root, Collection<File> includes) throws IOException {
        ZipUtil.compressFiles(zipFile, root, includes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFiles(File zipFile, File root, Collection<File> includes, boolean createMD5) throws IOException {
        OutputStream oStream = new FileOutputStream(zipFile);
        if (createMD5) {
            oStream = new MD5OutputStream(oStream);
        }
        try {
            ZipOutputStream zipOStream = new ZipOutputStream(oStream);
            for (File file : includes) {
                String entryName = ZipUtil.toZipEntryName(root, file);
                ZipEntry entry = new ZipEntry(entryName);
                entry.setTime(file.lastModified());
                zipOStream.putNextEntry(entry);
                if (file.isFile() && file.canRead()) {
                    int bytesIn;
                    byte[] readBuffer = new byte[8192];
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 8192);
                    while ((bytesIn = bis.read(readBuffer, 0, 8192)) != -1) {
                        zipOStream.write(readBuffer, 0, bytesIn);
                    }
                    bis.close();
                }
                zipOStream.closeEntry();
            }
            zipOStream.close();
            if (createMD5) {
                String md5hash = MD5.asHex(((MD5OutputStream)oStream).hash());
                File md5File = new File(zipFile.getAbsoluteFile() + ".md5");
                FileUtil.writeString(md5File, md5hash);
            }
        }
        finally {
            oStream.close();
        }
    }

    public static void compress(File zipFile, File fileOrDirectory) throws IOException {
        ZipUtil.compress(zipFile, fileOrDirectory, null, false);
    }

    public static void compress(File zipFile, File fileOrDirectory, FileFilter filter) throws IOException {
        ZipUtil.compress(zipFile, fileOrDirectory, filter, false);
    }

    public static void compress(File zipFile, File fileOrDirectory, FileFilter filter, boolean createMD5) throws IOException {
        if (filter == null) {
            filter = ALL_FILE_FILTER;
        }
        List<Object> files = new ArrayList();
        if (fileOrDirectory.isDirectory()) {
            files = FileUtil.getFilteredElements(fileOrDirectory, filter, true);
        } else if (filter.accept(fileOrDirectory)) {
            files.add(fileOrDirectory);
        }
        ZipUtil.compressFiles(zipFile, fileOrDirectory.getParentFile(), files, createMD5);
    }

    private static String toZipEntryName(File root, File file) {
        String rootPath;
        String result = file.getPath();
        if (root != null && result.startsWith(rootPath = root.getPath())) {
            result = result.substring(rootPath.length());
        }
        result = result.replace('\\', '/');
        if (file.isDirectory()) {
            result = result + '/';
        }
        while (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scan(File zipFile, File targetDir, List<String> newFiles, List<String> existingFiles, FileFilter excludeFilter, String renameFrom, String renameTo) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            boolean findExisting = targetDir != null && targetDir.exists();
            boolean filter = findExisting && excludeFilter != null;
            boolean rename = renameFrom != null && renameTo != null;
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (rename) {
                    entryName = entryName.replaceAll(renameFrom, renameTo);
                }
                String name = ZipUtil.convertToLocalEntryName(entryName);
                if (findExisting || filter) {
                    File file = new File(targetDir, name);
                    if (filter && excludeFilter.accept(file)) continue;
                    if (file.exists()) {
                        existingFiles.add(name);
                        continue;
                    }
                }
                newFiles.add(name);
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    public static List<String>[] scanAndExplodeZip(File source, File root, FileFilter excludeFilter) throws IOException {
        ArrayList<String> overwrittenFiles = new ArrayList<String>();
        ArrayList<String> newFiles = new ArrayList<String>();
        ZipUtil.scan(source, root, newFiles, overwrittenFiles, excludeFilter, null, null);
        return new List[]{newFiles, overwrittenFiles};
    }

    public static String uncompress(File file, File targetDir, List<String> toTreate, String renameFrom, String renameTo) throws IOException {
        ZipEntry entry;
        boolean rename;
        String result = "";
        ZipInputStream in = new ZipInputStream(new FileInputStream(file));
        if (toTreate == null || toTreate.isEmpty()) {
            return ZipUtil.uncompressAndRename(file, targetDir, renameFrom, renameTo);
        }
        boolean bl = rename = renameFrom != null && renameTo != null;
        while ((entry = in.getNextEntry()) != null) {
            int len;
            String name = entry.getName();
            result = rename ? ZipUtil.convertToLocalEntryName(name.replaceAll(renameFrom, renameTo)) : ZipUtil.convertToLocalEntryName(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("open [" + name + "] : " + result));
            }
            if (!toTreate.contains(result)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("copy [" + name + "] : " + result));
            }
            File target = new File(targetDir, result);
            if (entry.isDirectory()) {
                target.mkdirs();
                continue;
            }
            target.getParentFile().mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).close();
        }
        in.close();
        return result;
    }

    public static String convertToZipEntryName(String txt, boolean isDir) {
        String s = txt.replaceAll(LOCAL_SEP_PATTERN, "/");
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s + (isDir ? "/" : "");
    }

    protected static String convertToLocalEntryName(String txt) {
        String s = txt.replaceAll("/", LOCAL_SEP_PATTERN);
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

