/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: FileService.java 1870 2010-12-27 12:35:52Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-services/src/main/java/com/jurismarches/vradi/services/FileService.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.services;

import java.io.File;

/**
 * File management service.
 * 
 * @author chatellier
 * @version $Revision: 1870 $
 * 
 * Last update : $Date: 2010-12-27 13:35:52 +0100 (lun., 27 déc. 2010) $
 * By : $Author: sletellier $
 */
public interface FileService {

    /**
     * Upload a template on server.
     * 
     * @param file file to upload
     * @param extensionName extension name to put file into
     * 
     * @return file uri to reference file
     * @throws VradiException throw VradiException if exception is occured
     */
    String uploadTemplate(File file, String extensionName) throws VradiException;

    /**
     * Download file.
     * 
     * File may be temporary.
     * 
     * @param extensionName extension name
     * @param templateName template name
     * 
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadTemplate(String extensionName, String templateName) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param convertUrl if convertion url is necessary
     * @param extensionName extension name
     * @param templateName template name
     *
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadTemplate(boolean convertUrl, String extensionName, String templateName) throws VradiException;

    /**
     * Upload a web harvest script on server.
     *
     * @param file file to upload
     * @return file uri to reference file
     * @throws VradiException throw VradiException if exception is occured
     */
    String uploadWebHarvestScript(File file) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param uri file uri to download
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadWebHarvestScript(String uri) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param convertUrl if convertion url is necessary
     * @param uri file uri to download
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadWebHarvestScript(boolean convertUrl, String uri) throws VradiException;

    /**
     * Download pdf file.
     * 
     * File may be temporary.
     * 
     * @param uri file uri to download
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadPDF(String uri) throws VradiException;

    /**
     * Download pdf file.
     *
     * File may be temporary.
     *
     * @param convertUrl if convertion url is necessary
     * @param uri file uri to download
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
     File downloadPDF(boolean convertUrl, String uri) throws VradiException;

    /**
     * Download pdf file.
     *
     * @param uri corresponding to history
     * @return url to go to file
     * @throws VradiException throw VradiException if exception is occured
     */
    String getPDFUrl(String uri) throws VradiException;

    /**
     * Upload a temporary file (for example for export).
     *
     * @param file The file to upload
     * @return an absolute URI on server file system
     * @throws VradiException if an exception occurred
     */
    String uploadTempFile(File file) throws VradiException;

    /**
     * Upload a form attachment.
     *
     * @param file file to upload
     * @param formId form id
     * @return file uri to reference file
     * @throws VradiException if an exception occurred
     */
    String uploadFormAttachment(File file, String formId) throws VradiException;

    /**
     * Download file.
     * 
     * File may be temporary.
     * 
     * @param uri file uri to download
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadFormAttachment(String uri) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param convertUrl if convertion url is necessary
     * @param fileName to download
     * @param formId form id
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
     File downloadFormAttachment(boolean convertUrl, String fileName, String formId) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param fileName to download
     * @param formId concerned
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadFormAttachment(String fileName, String formId) throws VradiException;
/**
     * Upload a session attachment.
     *
     * @param file file to upload
     * @param sessionId session id
     * @return file uri to reference file
     * @throws VradiException if an exception occurred
     */
    String uploadSessionAttachment(File file, String sessionId) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param uri file uri to download
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadSessionAttachment(String uri) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param convertUrl if convertion url is necessary
     * @param fileName to download
     * @param sessionId session id
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
     File downloadSessionAttachment(boolean convertUrl, String fileName, String sessionId) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param fileName to download
     * @param sessionId concerned
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadSessionAttachment(String fileName, String sessionId) throws VradiException;

    /**
     * Upload a form attachement.
     * 
     * @param file file to upload
     * @param formId form id
     * @return file uri to reference file
     * @throws VradiException throw VradiException if exception is occured
     */
    String uploadFormEmbeddedFile(File file, String formId) throws VradiException;

    /**
     * Download file.
     * 
     * File may be temporary.
     * 
     * @param uri file uri to download
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadFormEmbeddedFile(String uri) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param fileName to download
     * @param formId form id
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadFormEmbeddedFile(String fileName, String formId) throws VradiException;

    /**
     * Download file.
     *
     * File may be temporary.
     *
     * @param convertUrl if convertion url is necessary
     * @param fileName to download
     * @param formId form id
     * @return locally downloaded file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadFormEmbeddedFile(boolean convertUrl, String fileName, String formId) throws VradiException;

    String getFormEmbeddedUrl(String fileName, String formId) throws VradiException;
    /**
     * Download request histiory file.
     *
     * File may be temporary.
     *
     * @param uri corresponding to history
     * @return url to go to file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadRequestHistory(String uri) throws VradiException;

    /**
     * Download request history file.
     *
     * File may be temporary.
     *
     * @param convertUrl if convertion url is necessary
     * @param uri corresponding to history
     * @return url to go to file
     * @throws VradiException throw VradiException if exception is occured
     */
    File downloadRequestHistory(boolean convertUrl, String uri) throws VradiException;

    /**
     * Get the url of request history.
     *
     * @param uri corresponding to history
     * @return url to go to file
     * @throws VradiException throw VradiException if exception is occured
     */
    String getRequestHistoryURL(String uri) throws VradiException;
}
