/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.VradiServiceConfigurationHelper;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.GroupFormsImpl;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.entities.ModificationTagImpl;
import com.jurismarches.vradi.entities.QueryMakerImpl;
import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.ThesaurusImpl;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.VradiUserImpl;
import com.jurismarches.vradi.entities.WebHarvestStreamImpl;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStreamImpl;
import com.jurismarches.vradi.services.ServiceMigration;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class ServiceFactory {
    private static final Log log = LogFactory.getLog(ServiceFactory.class);
    protected static WikittyService vradiWikittyService;
    protected static VradiStorageService vradiStorageService;
    protected static WikittyProxy wikittyProxy;
    protected static VradiServiceConfiguration config;

    public static synchronized VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = new VradiStorageServiceImpl();
        }
        return vradiStorageService;
    }

    public static synchronized WikittyService getWikittyService() {
        if (vradiWikittyService == null) {
            ServiceFactory.getWikittyService(config);
        }
        return vradiWikittyService;
    }

    public static synchronized WikittyService getWikittyService(ApplicationConfig config) {
        if (vradiWikittyService == null) {
            vradiWikittyService = WikittyServiceFactory.buildWikittyService((ApplicationConfig)config);
        }
        return vradiWikittyService;
    }

    public static synchronized WikittyProxy getWikittyProxy() {
        if (wikittyProxy == null) {
            WikittyService wikittyService = ServiceFactory.getWikittyService();
            wikittyProxy = new WikittyProxy(wikittyService);
            ServiceFactory.updateExtensions(wikittyProxy);
            ServiceFactory.reindexData(wikittyProxy);
        }
        return wikittyProxy;
    }

    static void updateExtensions(WikittyProxy localWikittyProxy) {
        List<WikittyExtension> extensions = Arrays.asList(ClientImpl.extensionClient, FormImpl.extensionForm, GroupImpl.extensionGroup, InfogeneImpl.extensionInfogene, ModificationTagImpl.extensionModificationTag, QueryMakerImpl.extensionQueryMaker, RootThesaurusImpl.extensionRootThesaurus, SendingImpl.extensionSending, SessionImpl.extensionSession, StatusImpl.extensionStatus, ThesaurusImpl.extensionThesaurus, WikittyTreeNodeImpl.extensionWikittyTreeNode, UserImpl.extensionUser, VradiUserImpl.extensionVradiUser, WebHarvestStreamImpl.extensionWebHarvestStream, WikittyUserImpl.extensionWikittyUser, XmlFieldBindingImpl.extensionXmlFieldBinding, XmlStreamImpl.extensionXmlStream, GroupFormsImpl.extensionGroupForms);
        localWikittyProxy.storeExtension(extensions);
    }

    protected static void reindexData(WikittyProxy localWikittyProxy) {
        try {
            String currentVersion = VradiServiceConfigurationHelper.getApplicationVersion(config);
            String lastVersion = VradiServiceConfigurationHelper.getServiceVersion(config);
            if (!currentVersion.equals(lastVersion)) {
                ServiceMigration.versionChangeMigration(lastVersion, currentVersion, localWikittyProxy);
                VradiServiceConfigurationHelper.setServiceVersion(config, currentVersion);
                config.saveForUser(new String[0]);
            } else if (log.isInfoEnabled()) {
                log.info((Object)"No version change, skipping reindexing.");
            }
            ServiceMigration.configureMigration();
        }
        catch (Exception eee) {
            log.error((Object)"Failled to reindex data : ", (Throwable)eee);
        }
    }

    static {
        try {
            ConverterUtil.initConverters();
            config = VradiServiceConfiguration.getInstance(new String[0]);
            I18n.init(VradiServiceConfigurationHelper.getLocale(config));
        }
        catch (Exception eee) {
            log.error((Object)"Cant initialize Service factory : ", (Throwable)eee);
        }
    }
}

