/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import org.webharvest.exception.PluginException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.DatabasePlugin;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class DbParamPlugin
extends WebHarvestPlugin {
    @Override
    public String getName() {
        return "db-param";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        BaseProcessor processor = scraper.getRunningProcessorOfType(DatabasePlugin.class);
        if (processor != null) {
            DatabasePlugin databasePlugin = (DatabasePlugin)processor;
            String type = this.evaluateAttribute("type", scraper);
            Variable body = this.executeBody(scraper, context);
            if (CommonUtil.isEmptyString(type)) {
                ListVariable list;
                type = "text";
                if (body.getWrappedObject() instanceof byte[]) {
                    type = "binary";
                } else if (body instanceof ListVariable && (list = (ListVariable)body).toList().size() == 1 && list.get(0).getWrappedObject() instanceof byte[]) {
                    type = "binary";
                }
            }
            databasePlugin.addDbParam(body, type);
            return new NodeVariable("?");
        }
        throw new PluginException("Cannot use db-param attach plugin out of database plugin context!");
    }

    @Override
    public String[] getValidAttributes() {
        return new String[]{"type"};
    }

    @Override
    public String[] getAttributeValueSuggestions(String attributeName) {
        if ("type".equalsIgnoreCase(attributeName)) {
            return new String[]{"int", "long", "double", "text", "binary"};
        }
        return null;
    }
}

