/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.services.FileService;
import com.jurismarches.vradi.services.VradiException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileServiceImpl
implements FileService {
    @Override
    public String uploadTemplate(File file, String extensionName) throws VradiException {
        String fileuri = null;
        try {
            File templatesDir = VradiServiceConfiguration.getInstance(new String[0]).getTemplatesDir();
            File templateDir = new File(templatesDir, extensionName);
            templateDir.mkdirs();
            File copyOfTemplate = new File(templateDir, file.getName());
            FileUtils.copyFile((File)file, (File)copyOfTemplate);
            fileuri = copyOfTemplate.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }
        return fileuri;
    }

    @Override
    public File downloadTemplate(String extensionName, String templateName) {
        File templateFile = null;
        if (templateName != null) {
            File templatesDir = VradiServiceConfiguration.getInstance(new String[0]).getTemplatesDir();
            File templateDir = new File(templatesDir, extensionName);
            templateFile = new File(templateDir, templateName);
        }
        return templateFile;
    }

    @Override
    public String uploadWebHarvestScript(File file) throws VradiException {
        String fileuri = null;
        try {
            File scriptsDir = VradiServiceConfiguration.getInstance(new String[0]).getWebHarvestScriptDir();
            File scriptFile = new File(scriptsDir, file.getName());
            FileUtils.copyFile((File)file, (File)scriptFile);
            fileuri = scriptFile.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }
        return fileuri;
    }

    @Override
    public File downloadWebHarvestScript(String uri) {
        File scriptsDir = VradiServiceConfiguration.getInstance(new String[0]).getWebHarvestScriptDir();
        File scriptFile = new File(scriptsDir, uri);
        return scriptFile;
    }

    @Override
    public File downloadPDF(String uri) {
        File pdfDir = VradiServiceConfiguration.getInstance(new String[0]).getPdfDir();
        File pdfFile = new File(pdfDir, uri);
        return pdfFile;
    }

    @Override
    public String uploadFormAttachment(File file, String formId) throws VradiException {
        String fileuri = null;
        try {
            File attachementsDir = VradiServiceConfiguration.getInstance(new String[0]).getAttachmentsDir();
            File attachementDir = new File(attachementsDir, formId);
            attachementDir.mkdirs();
            File copyOfFormAttachement = new File(attachementDir, file.getName());
            FileUtils.copyFile((File)file, (File)copyOfFormAttachement);
            fileuri = copyOfFormAttachement.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }
        return fileuri;
    }

    @Override
    public String uploadTempFile(File file) throws VradiException {
        String fileURI;
        try {
            File tempDir = VradiServiceConfiguration.getInstance(new String[0]).getTempDir();
            tempDir.mkdirs();
            File copyOfTempFile = new File(tempDir, file.getName());
            FileUtils.copyFile((File)file, (File)copyOfTempFile);
            fileURI = "file://" + copyOfTempFile.getAbsolutePath();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }
        return fileURI;
    }

    @Override
    public File downloadFormAttachment(String uri) {
        File attachmentDir = VradiServiceConfiguration.getInstance(new String[0]).getAttachmentsDir();
        File attachmentFile = new File(attachmentDir, uri);
        return attachmentFile;
    }

    @Override
    public String uploadFormEmbeddedFile(File file, String formId) throws VradiException {
        String fileuri = null;
        try {
            File embeddedsDir = VradiServiceConfiguration.getInstance(new String[0]).getEmbeddedFilesDir();
            File embeddedDir = new File(embeddedsDir, formId);
            embeddedDir.mkdirs();
            File copyOfEmbeddedFile = new File(embeddedDir, file.getName());
            FileUtils.copyFile((File)file, (File)copyOfEmbeddedFile);
            fileuri = copyOfEmbeddedFile.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }
        return fileuri;
    }

    @Override
    public File downloadFormEmbeddedFile(String uri) {
        File parentDir = VradiServiceConfiguration.getInstance(new String[0]).getEmbeddedFilesDir();
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile;
    }

    @Override
    public File downloadRequestHistory(String uri) throws VradiException {
        File parentDir = VradiServiceConfiguration.getInstance(new String[0]).getQueryHistoryDir();
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile;
    }

    @Override
    public String getRequestHistoryURL(String uri) throws VradiException {
        File parentDir = VradiServiceConfiguration.getInstance(new String[0]).getQueryHistoryDir();
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile.toURI().toString();
    }
}

