/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: RangeFilter.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-services/src/main/java/com/jurismarches/vradi/services/search/RangeFilter.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.services.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.math.NumberUtils;

/**
 * RangeFilter.
 *
 * @author $Author: tchemit $
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 4 mars 2010 10:38:16
 */
public class RangeFilter extends CompareFilter {
    private static final long serialVersionUID = 1L;

    protected String lowerValue = null;
    protected String upperValue = null;
    
    public RangeFilter(String term, String lowerValue, String upperValue) {
        super(term, lowerValue);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }
    
    @Override
    public void setValue(String value) {
        this.value = value;
        this.lowerValue = value;
    }
    
    public void setLowerValue(String value) {
        this.lowerValue = value;
    }
    public String getLowerValue() {
        return lowerValue;
    }
    
    public void setUpperValue(String value) {
        this.upperValue = value;
    }
    public String getUpperValue() {
        return upperValue;
    }
    
    @Override
    public boolean isNumber() {
        return NumberUtils.isNumber(lowerValue) && NumberUtils.isNumber(upperValue);
    }
    
    @Override
    public boolean match(Pattern pattern) {
        Matcher lowerMatcher = pattern.matcher(lowerValue);
        Matcher upperMatcher = pattern.matcher(upperValue);
        return lowerMatcher.matches() && upperMatcher.matches();
    }
    
    @Override
    public String toString() {
        return String.format("%s = [%s TO %s]", term, lowerValue, upperValue);
    }
}
