/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: VradiServiceMain.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-services/src/main/java/com/jurismarches/vradi/VradiServiceMain.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

/**
 * This module do nothing except with options :
 *
 * -- reIndexSolr
 *
 * @author sletellier <letellier@codelutin.com>
 */
public class VradiServiceMain {

    /** log. */
    private static final Log log = LogFactory.getLog(VradiServiceMain.class);

    public static void main(String[] args) {
        
        // Initialise config
        VradiServiceConfiguration config = VradiServiceConfiguration.getInstance(args);
        I18n.init(config.getLocale());

        try {
            // Launch actions
            config.doAction(VradiServiceConfiguration.STEP_AFTER_INIT);
        } catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't run actions ", eee);
            }
        }
    }
}
