/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;

public class JDomSerializer {
    private DefaultJDOMFactory factory;
    protected CleanerProperties props;
    protected boolean escapeXml = true;

    public JDomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public JDomSerializer(CleanerProperties props) {
        this(props, true);
    }

    public Document createJDom(TagNode rootNode) {
        this.factory = new DefaultJDOMFactory();
        Element rootElement = this.factory.element(rootNode.getName());
        Document document = this.factory.document(rootElement);
        this.createSubnodes(rootElement, rootNode.getChildren());
        return document;
    }

    private void createSubnodes(Element element, List tagChildren) {
        if (tagChildren != null) {
            Iterator it = tagChildren.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (item instanceof CommentToken) {
                    CommentToken commentToken = (CommentToken)item;
                    Comment comment = this.factory.comment(commentToken.getContent());
                    element.addContent((Content)comment);
                    continue;
                }
                if (item instanceof ContentToken) {
                    boolean specialCase;
                    String nodeName = element.getName();
                    ContentToken contentToken = (ContentToken)item;
                    String content = contentToken.getContent();
                    boolean bl = specialCase = this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(nodeName) || "style".equalsIgnoreCase(nodeName));
                    if (this.escapeXml && !specialCase) {
                        content = Utils.escapeXml(content, this.props, true);
                    }
                    CDATA text = specialCase ? this.factory.cdata(content) : this.factory.text(content);
                    element.addContent((Content)text);
                    continue;
                }
                if (item instanceof TagNode) {
                    TagNode subTagNode = (TagNode)item;
                    Element subelement = this.factory.element(subTagNode.getName());
                    Map attributes = subTagNode.getAttributes();
                    Iterator entryIterator = attributes.entrySet().iterator();
                    while (entryIterator.hasNext()) {
                        Map.Entry entry = entryIterator.next();
                        String attrName = (String)entry.getKey();
                        String attrValue = (String)entry.getValue();
                        subelement.setAttribute(attrName, attrValue);
                    }
                    this.createSubnodes(subelement, subTagNode.getChildren());
                    element.addContent((Content)subelement);
                    continue;
                }
                if (!(item instanceof List)) continue;
                List sublist = (List)item;
                this.createSubnodes(element, sublist);
            }
        }
    }
}

