/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiException;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class ClientManager {
    private static final Log log = LogFactory.getLog(ClientManager.class);
    protected WikittyProxy wikittyProxy;

    public ClientManager(WikittyProxy wikittyProxy) {
        this.wikittyProxy = wikittyProxy;
    }

    public void deleteClient(String clientId) throws VradiException {
        List<User> users = this.getUsersByClient(clientId);
        for (User user : users) {
            this.deleteUser(user.getWikittyId());
        }
        this.wikittyProxy.delete(clientId);
    }

    public void deleteUser(String userId) throws VradiException {
        List<Group> groups = this.getGroupsForUser(userId);
        for (Group group : groups) {
            group.removeUser(userId);
        }
        Search search = Search.query();
        search = search.eq(Element.ELT_EXTENSION, "Sending");
        search = search.eq("Sending.user", userId);
        Criteria criteria = search.criteria();
        PagedResult sendings = this.wikittyProxy.findAllByCriteria(Sending.class, criteria);
        List all = sendings.getAll();
        ArrayList<String> sendingIds = new ArrayList<String>();
        for (Sending sending : all) {
            String sendingId = sending.getWikittyId();
            sendingIds.add(sendingId);
        }
        this.wikittyProxy.delete(sendingIds);
        search = Search.query();
        search = search.eq(Element.ELT_EXTENSION, "Session");
        search = search.eq("Session.sending", sendingIds);
        criteria = search.criteria();
        PagedResult sessionsResult = this.wikittyProxy.findAllByCriteria(Session.class, criteria);
        List sessions = sessionsResult.getAll();
        for (Session session : sessions) {
            for (String sendingId : sendingIds) {
                session.removeSending(sendingId);
            }
        }
        this.wikittyProxy.store(sessions);
        this.wikittyProxy.delete(sendingIds);
        this.wikittyProxy.store(groups);
        this.wikittyProxy.delete(userId);
    }

    public void deleteGroup(String groupId) throws VradiException {
        this.wikittyProxy.delete(groupId);
    }

    public User getUser(String userId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUser(" + userId + ")"));
        }
        User user = (User)this.wikittyProxy.restore(User.class, userId);
        return user;
    }

    public Client getClient(String clientId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClient(" + clientId + ")"));
        }
        Client client = (Client)this.wikittyProxy.restore(Client.class, clientId);
        return client;
    }

    public Group getGroup(String groupId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroup(" + groupId + ")"));
        }
        Group group = (Group)this.wikittyProxy.restore(Group.class, groupId);
        return group;
    }

    public List<User> getGroupUsers(String groupId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupUsers(" + groupId + ")"));
        }
        ArrayList<User> users = new ArrayList<User>();
        Group group = this.getGroup(groupId);
        if (group != null && group.getUser() != null) {
            ArrayList<String> userIds = new ArrayList<String>(group.getUser());
            List restore = this.wikittyProxy.restore(User.class, userIds);
            users.addAll(restore);
        }
        return users;
    }

    public List<User> getUsersByClient(String clientId) {
        Search search = Search.query().eq("User.client", clientId);
        Criteria criteria = search.criteria();
        criteria.addSortAscending("User.name");
        PagedResult usersResult = this.wikittyProxy.findAllByCriteria(User.class, criteria);
        ArrayList<User> users = new ArrayList<User>(usersResult.getAll());
        return users;
    }

    public List<Group> getGroupsForUser(String userId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get Groups for user : " + userId));
        }
        Search search = Search.query();
        search = search.eq(Element.ELT_EXTENSION, "Group");
        search = search.contains("Group.user", userId);
        Criteria criteria = search.criteria();
        PagedResult groups = this.wikittyProxy.findAllByCriteria(Group.class, criteria);
        List all = groups.getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)(all.size() + " groups found"));
        }
        return all;
    }

    public Client getClientByUserId(String userId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClientByUserId(" + userId + ")"));
        }
        User user = this.getUser(userId);
        String clientId = user.getClient();
        return this.getClient(clientId);
    }

    public List<Client> getAllClients() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllClients()");
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Client");
        Criteria criteria = search.criteria();
        PagedResult clients = this.wikittyProxy.findAllByCriteria(Client.class, criteria);
        List all = clients.getAll();
        return new ArrayList<Client>(all);
    }

    public List<User> getAllUsers() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllUsers()");
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "User");
        Criteria criteria = search.criteria();
        PagedResult users = this.wikittyProxy.findAllByCriteria(User.class, criteria);
        List all = users.getAll();
        return new ArrayList<User>(all);
    }

    public List<Group> getAllGroups() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllGroups()");
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Group");
        Criteria criteria = search.criteria();
        PagedResult groups = this.wikittyProxy.findAllByCriteria(Group.class, criteria);
        List all = groups.getAll();
        return new ArrayList<Group>(all);
    }

    public void archiveQueries(QueryMaker queryMaker) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("archiveQueries(id:" + queryMaker.getWikittyId() + "; version:" + queryMaker.getWikittyVersion() + ")"));
        }
        try {
            SyndFeed feed;
            String extName;
            Set<String> updatedQueries;
            String wikittyId = queryMaker.getWikittyId();
            Criteria criteria = Search.query().eq(Element.ELT_ID, wikittyId).criteria();
            QueryMaker restored = (QueryMaker)this.wikittyProxy.findByCriteria(QueryMaker.class, criteria);
            if (restored != null && restored.getQueries() != null) {
                Collection disjunction;
                Set<String> restoredQueries = restored.getQueries();
                updatedQueries = queryMaker.getQueries();
                if (updatedQueries != null && (disjunction = CollectionUtils.disjunction(restoredQueries, updatedQueries)).isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Disjunction between new and old queryMaker is empty");
                    }
                    return;
                }
            } else {
                boolean updatedQueriesEmpty;
                boolean restoredQueriesEmpty = restored == null || restored.getQueries() == null || restored.getQueries().isEmpty();
                updatedQueries = queryMaker.getQueries();
                boolean bl = updatedQueriesEmpty = updatedQueries == null || updatedQueries.isEmpty();
                if (restoredQueriesEmpty && updatedQueriesEmpty) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Restored query and updated query are empty");
                    }
                    return;
                }
            }
            if (queryMaker instanceof Client) {
                extName = "Client";
            } else if (queryMaker instanceof User) {
                extName = "User";
            } else if (queryMaker instanceof Group) {
                extName = "Group";
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Extention not found, stopping archiving queries");
                }
                return;
            }
            File queryHistoryDir = VradiServiceConfiguration.getInstance(new String[0]).getQueryHistoryDir();
            File feedFile = new File(queryHistoryDir, wikittyId + ".rss");
            if (feedFile.exists()) {
                SyndFeedInput input = new SyndFeedInput();
                feed = input.build(feedFile);
            } else {
                feedFile.getParentFile().mkdirs();
                feedFile.createNewFile();
                Object queryMakerName = queryMaker.getField(extName, "name");
                feed = new SyndFeedImpl();
                feed.setFeedType("rss_2.0");
                feed.setTitle("Requetes de " + queryMakerName);
                feed.setDescription("Historique des requetes");
                feed.setLink("");
                feed.setAuthor("Vradi");
                feed.setPublishedDate(new Date());
            }
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setPublishedDate(new Date());
            if (queryMaker.getExtensionNames().contains("ModificationTag")) {
                entry.setAuthor((String)queryMaker.getField("ModificationTag", "lastModifier"));
            }
            StringBuffer sb = new StringBuffer("<ul>");
            Set<String> queries = queryMaker.getQueries();
            if (queries != null) {
                for (String query : queries) {
                    try {
                        QueryBean queryBean = new QueryBean(query);
                        sb.append("<li>").append("<name><![CDATA[").append(queryBean.getName()).append("]]</name>").append("<description><![CDATA[").append(queryBean.getDescription()).append("]]</description>").append("<query><![CDATA[").append(queryBean.getQuery()).append("]]</query>").append("</li>");
                    }
                    catch (Exception e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            sb.append("</ul>");
            SyndContentImpl syndQuery = new SyndContentImpl();
            syndQuery.setType("text/html");
            syndQuery.setValue(sb.toString());
            entry.setDescription((SyndContent)syndQuery);
            List entries = feed.getEntries();
            entries.add(0, entry);
            feed.setEntries(entries);
            FileWriter writer = new FileWriter(feedFile);
            SyndFeedOutput output = new SyndFeedOutput();
            output.output(feed, (Writer)writer);
            ((Writer)writer).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("history recorded to: " + feedFile));
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't archive queries", (Throwable)eee);
            }
            throw new VradiException("Can't archive queries", eee);
        }
    }

    public String getQueryHistoryFile(String id) {
        File queryHistoryDir = VradiServiceConfiguration.getInstance(new String[0]).getQueryHistoryDir();
        File queryHistoryFile = new File(queryHistoryDir, id + ".rss");
        if (!queryHistoryFile.exists()) {
            return null;
        }
        String dirName = queryHistoryDir.getName();
        String filePath = queryHistoryFile.getAbsolutePath();
        int indexOf = filePath.indexOf(dirName);
        filePath = filePath.substring(indexOf);
        return filePath;
    }
}

