/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.WikittyExtensionStorage;
import org.nuiton.wikitty.WikittySearchEngin;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyStorage;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.WikittyTreeNode;
import org.nuiton.wikitty.WikittyTreeNodeHelper;
import org.nuiton.wikitty.WikittyTreeNodeImpl;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Search;

public class WikittyServiceImpl
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceImpl.class);
    protected WikittyExtensionMigration defaultExtensionMigration = new WikittyExtensionMigrationRename();
    protected WikittySearchEngin searchEngin;
    protected WikittyExtensionStorage extensionStorage;
    protected WikittyStorage wikittyStorage;

    protected WikittyServiceImpl() {
    }

    public WikittyServiceImpl(WikittyExtensionStorage extensionStorage, WikittyStorage wikittyStorage, WikittySearchEngin searchEngin) {
        this.extensionStorage = extensionStorage;
        this.wikittyStorage = wikittyStorage;
        this.searchEngin = searchEngin;
    }

    protected WikittySearchEngin getSearchEngin() {
        return this.searchEngin;
    }

    protected WikittyExtensionStorage getExtensionStorage() {
        return this.extensionStorage;
    }

    protected WikittyStorage getWikittyStorage() {
        return this.wikittyStorage;
    }

    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("Can't add listener on " + WikittyServiceImpl.class.getName());
    }

    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("Can't remove listener on " + WikittyServiceImpl.class.getName());
    }

    @Override
    public String login(String login, String password) {
        log.warn((Object)"login asked, but there is no security service");
        return null;
    }

    @Override
    public void logout(String securityToken) {
        log.warn((Object)"logout asked, but there is no security service");
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return true;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return true;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return true;
    }

    protected void checkConstraint(Collection<Wikitty> wikitties) {
        for (Wikitty w : wikitties) {
            for (WikittyExtension ext : w.getExtensions()) {
                for (String fieldName : ext.getFieldNames()) {
                    FieldType type = ext.getFieldType(fieldName);
                    if (!type.isNotNull() || null != w.getFieldAsObject(ext.getName(), fieldName)) continue;
                    throw new WikittyException(String.format("Field %s must not be null", fieldName));
                }
            }
        }
    }

    @Override
    public UpdateResponse store(String securityToken, WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
        if (!(wikitties instanceof Set)) {
            wikitties = new LinkedHashSet<Wikitty>(wikitties);
        }
        this.checkConstraint(wikitties);
        LinkedHashSet<WikittyExtension> allExtensions = new LinkedHashSet<WikittyExtension>();
        for (Wikitty w : wikitties) {
            allExtensions.addAll(w.getExtensions());
        }
        UpdateResponse extUpdate = this.getExtensionStorage().store(transaction, allExtensions);
        UpdateResponse wikUpdate = this.getWikittyStorage().store(transaction, wikitties, force);
        UpdateResponse indexUpdate = this.getSearchEngin().store(transaction, wikitties);
        UpdateResponse result = new UpdateResponse();
        result.add(extUpdate);
        result.add(wikUpdate);
        result.add(indexUpdate);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        if (wikitty != null) {
            WikittyTransaction transaction = new WikittyTransaction();
            try {
                transaction.begin();
                List<Wikitty> wikitties = Arrays.asList(wikitty);
                UpdateResponse result = this.store(securityToken, transaction, wikitties, false);
                transaction.commit();
                return result;
            }
            catch (WikittyException ex) {
                transaction.rollback();
                throw ex;
            }
            catch (Exception eee) {
                transaction.rollback();
                throw new WikittyException("Can't store wikitty", eee);
            }
        }
        throw new WikittyException("You can't store null wikitty object");
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            UpdateResponse result = this.store(securityToken, transaction, wikitties, false);
            transaction.commit();
            return result;
        }
        catch (WikittyException ex) {
            transaction.rollback();
            throw ex;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't store wikitty", eee);
        }
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            UpdateResponse result = this.store(securityToken, transaction, wikitties, force);
            transaction.commit();
            return result;
        }
        catch (WikittyException ex) {
            transaction.rollback();
            throw ex;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't store wikitty", eee);
        }
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            List<String> result = this.getExtensionStorage().getAllExtensionIds(transaction);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't retrieve all extension's ids", eee);
        }
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            List<String> result = this.getExtensionStorage().getAllExtensionsRequires(transaction, extensionName);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(String.format("Can't retrieve all required extension for %s", extensionName), eee);
        }
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        UpdateResponse result = this.getExtensionStorage().store(transaction, exts);
        return result;
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            UpdateResponse result = this.storeExtension(securityToken, transaction, exts);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't store extensions", eee);
        }
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyExtension ext) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            UpdateResponse result = this.storeExtension(securityToken, transaction, Arrays.asList(ext));
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't store extension", eee);
        }
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, WikittyTransaction transaction, String extensionId) {
        String name = WikittyExtension.computeName(extensionId);
        String version = WikittyExtension.computeVersion(extensionId);
        WikittyExtension result = this.getExtensionStorage().restore(transaction, name, version);
        return result;
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String extensionId) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            WikittyExtension result = this.restoreExtension(securityToken, transaction, extensionId);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("can't restore extensions", eee);
        }
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, WikittyTransaction transaction, String name) {
        String version = this.getExtensionStorage().getLastVersion(transaction, name);
        if (version == null) {
            return null;
        }
        WikittyExtension result = this.getExtensionStorage().restore(transaction, name, version);
        return result;
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            WikittyExtension result = this.restoreExtensionLastVersion(securityToken, transaction, name);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't restore extension", eee);
        }
    }

    protected Wikitty restore(String securityToken, WikittyTransaction transaction, String id) {
        if (id == null) {
            return null;
        }
        if (!this.getWikittyStorage().exists(transaction, id)) {
            return null;
        }
        if (this.getWikittyStorage().isDeleted(transaction, id)) {
            return null;
        }
        Wikitty result = this.getWikittyStorage().restore(transaction, id, new String[0]);
        if (result != null) {
            result = this.upgradeData(securityToken, transaction, result);
        }
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> ids) {
        ArrayList<Wikitty> result = new ArrayList<Wikitty>();
        for (String id : ids) {
            Wikitty w = this.restore(securityToken, transaction, id);
            if (w == null) continue;
            result.add(w);
        }
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            List<Wikitty> result = this.restore(securityToken, transaction, ids);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't restore wikitty collection", (Throwable)eee);
            }
            transaction.rollback();
            throw new WikittyException("Can't restore wikitty", eee);
        }
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty result = this.restore(securityToken, transaction, id);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't restore wikitty", eee);
        }
    }

    protected Wikitty upgradeData(String securityToken, WikittyTransaction transaction, Wikitty wikitty) {
        Wikitty result = wikitty;
        Collection<WikittyExtension> extensions = wikitty.getExtensions();
        for (WikittyExtension extension : extensions) {
            WikittyExtensionMigration migration;
            String extensionName = extension.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("extensionName=" + extensionName));
            }
            WikittyExtension currentExtension = extension;
            String currentExtensionVersion = currentExtension.getVersion();
            WikittyExtension lastExtension = this.restoreExtensionLastVersion(securityToken, transaction, extensionName);
            String lastExtensionVersion = lastExtension.getVersion();
            if (log.isDebugEnabled()) {
                log.debug((Object)("lastExtensionVersion=" + lastExtensionVersion));
            }
            if ((migration = WikittyExtensionMigration.migrationRegistry.get(extensionName)) == null) {
                migration = this.defaultExtensionMigration;
            }
            while (WikittyUtil.versionGreaterThan(lastExtensionVersion, currentExtensionVersion)) {
                String nextExtensionVersion = WikittyUtil.incrementMajorRevision(currentExtensionVersion);
                String nextExtensionId = WikittyExtension.computeId(extensionName, nextExtensionVersion);
                WikittyExtension nextExtension = this.restoreExtension(securityToken, transaction, nextExtensionId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("currentExtensionVersion=" + currentExtensionVersion));
                    log.debug((Object)("nextExtensionVersion=" + nextExtensionVersion));
                }
                if (nextExtension != null) {
                    result = migration.migrate(this, transaction, result, currentExtension, nextExtension);
                    currentExtension = nextExtension;
                }
                currentExtensionVersion = nextExtensionVersion;
            }
        }
        return result;
    }

    protected void delete(String securityToken, WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        LinkedHashSet<Wikitty> storedWikitties = new LinkedHashSet<Wikitty>();
        LinkedHashSet<String> idSet = new LinkedHashSet<String>(ids);
        Iterator i = idSet.iterator();
        while (i.hasNext()) {
            Wikitty treeNode;
            String id = (String)i.next();
            if (!this.getWikittyStorage().exists(transaction, id)) {
                i.remove();
                continue;
            }
            if (this.getWikittyStorage().isDeleted(transaction, id)) {
                i.remove();
                continue;
            }
            Criteria criteria = Search.query().eq("WikittyTreeNode.parent", id).criteria();
            List<String> wikittyNodesId = this.findAllByCriteria(securityToken, transaction, criteria).getAll();
            for (String wikittyNodeId : wikittyNodesId) {
                if (idSet.contains(wikittyNodeId)) continue;
                treeNode = this.restore(securityToken, transaction, wikittyNodeId);
                WikittyTreeNodeHelper.setParent(treeNode, null);
                storedWikitties.add(treeNode);
            }
            criteria = Search.query().eq("WikittyTreeNode.attachment", id).criteria();
            wikittyNodesId = this.findAllByCriteria(securityToken, transaction, criteria).getAll();
            for (String wikittyNodeId : wikittyNodesId) {
                if (idSet.contains(wikittyNodeId)) continue;
                treeNode = this.restore(securityToken, transaction, wikittyNodeId);
                WikittyTreeNodeHelper.removeAttachment(treeNode, id);
                storedWikitties.add(treeNode);
            }
        }
        this.getWikittyStorage().delete(transaction, idSet);
        this.getSearchEngin().delete(transaction, idSet);
        this.store(securityToken, transaction, storedWikitties, false);
    }

    @Override
    public void delete(String securityToken, String id) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            List<String> ids = Arrays.asList(id);
            this.delete(securityToken, transaction, ids);
            transaction.commit();
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't delete wikitty", eee);
        }
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            this.delete(securityToken, transaction, ids);
            transaction.commit();
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't delete wikitty", eee);
        }
    }

    @Override
    public void clear(String securityToken) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            this.getSearchEngin().clear(transaction);
            this.getWikittyStorage().clear(transaction);
            this.getExtensionStorage().clear(transaction);
            transaction.commit();
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't clear all data", eee);
        }
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        PagedResult<String> result = this.getSearchEngin().findAllByCriteria(transaction, criteria);
        return result;
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            PagedResult<String> result = this.findAllByCriteria(securityToken, transaction, criteria);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Error during find", eee);
        }
    }

    @Override
    public Wikitty findByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        criteria.setFirstIndex(0).setEndIndex(1);
        PagedResult<String> pages = this.findAllByCriteria(securityToken, transaction, criteria);
        Wikitty result = null;
        if (pages.size() > 0) {
            String id = pages.getFirst();
            result = this.restore(securityToken, transaction, id);
        }
        return result;
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty result = this.findByCriteria(securityToken, transaction, criteria);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Error during find", eee);
        }
    }

    protected WikittyTree restoreTree(String securityToken, WikittyTransaction transaction, String wikittyId) {
        Wikitty w = this.restore(securityToken, transaction, wikittyId);
        if (w == null) {
            return null;
        }
        if (!w.hasExtension("WikittyTreeNode")) {
            throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "WikittyTreeNode"));
        }
        WikittyTree tree = new WikittyTree();
        WikittyTreeNodeImpl node = new WikittyTreeNodeImpl(w);
        tree.setNode(node);
        WikittyTreeNodeImpl exempleNode = new WikittyTreeNodeImpl();
        exempleNode.setParent(wikittyId);
        Criteria criteria = Search.query(exempleNode.getWikitty()).criteria().setFirstIndex(0).setEndIndex(-1);
        PagedResult<String> childNodesId = this.findAllByCriteria(securityToken, transaction, criteria);
        for (String childNodeId : childNodesId.getAll()) {
            tree.addChild(this.restoreTree(securityToken, transaction, childNodeId));
        }
        return tree;
    }

    @Override
    public WikittyTree restoreTree(String securityToken, String wikittyId) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            WikittyTree tree = this.restoreTree(securityToken, transaction, wikittyId);
            transaction.commit();
            return tree;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't restore tree", eee);
        }
    }

    @Override
    public List<String> deleteTree(String securityToken, String thesaurusId) {
        List<String> deletedIds = null;
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            deletedIds = this.deleteTree(securityToken, transaction, thesaurusId);
            transaction.commit();
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't delete tree", eee);
        }
        return deletedIds;
    }

    public List<String> deleteTree(String securityToken, WikittyTransaction transaction, String treeNodeId) {
        List<String> allTreeNodeId = this.getRecursiveTreeNodeId(securityToken, transaction, treeNodeId);
        this.delete(securityToken, transaction, allTreeNodeId);
        return allTreeNodeId;
    }

    protected List<String> getRecursiveTreeNodeId(String securityToken, WikittyTransaction transaction, String treeNodeId) {
        Search search = Search.query();
        search = search.eq("WikittyTreeNode.parent", treeNodeId);
        Criteria criteria = search.criteria();
        PagedResult<String> childTreeNodeIds = this.findAllByCriteria(securityToken, transaction, criteria);
        ArrayList<String> treeNodeIds = new ArrayList<String>();
        treeNodeIds.add(treeNodeId);
        for (String childTreeNodeId : childTreeNodeIds.getAll()) {
            List<String> subTreeNodeIds = this.getRecursiveTreeNodeId(securityToken, transaction, childTreeNodeId);
            treeNodeIds.addAll(subTreeNodeIds);
        }
        return treeNodeIds;
    }

    @Override
    public Map.Entry<WikittyTreeNode, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty w = this.restore(securityToken, transaction, wikittyId);
            if (w == null) {
                transaction.commit();
                return null;
            }
            if (!w.hasExtension("WikittyTreeNode")) {
                throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "WikittyTreeNode"));
            }
            WikittyTreeNodeImpl node = new WikittyTreeNodeImpl(w);
            Integer count = this.getSearchEngin().findNodeCount(transaction, w, filter);
            AbstractMap.SimpleEntry<WikittyTreeNode, Integer> result = new AbstractMap.SimpleEntry<WikittyTreeNode, Integer>(node, count);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't restore node", eee);
        }
    }

    @Override
    public Map<WikittyTreeNode, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty w = this.restore(securityToken, transaction, wikittyId);
            if (w == null) {
                transaction.commit();
                return null;
            }
            if (!w.hasExtension("WikittyTreeNode")) {
                throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "WikittyTreeNode"));
            }
            LinkedHashMap<WikittyTreeNode, Integer> result = new LinkedHashMap<WikittyTreeNode, Integer>();
            Map<String, Integer> search = this.getSearchEngin().findAllChildrenCount(transaction, w, filter);
            Set<Map.Entry<String, Integer>> children = search.entrySet();
            for (Map.Entry<String, Integer> child : children) {
                Integer count = child.getValue();
                String id = child.getKey();
                Wikitty wikitty = this.restore(securityToken, transaction, id);
                WikittyTreeNodeImpl node = new WikittyTreeNodeImpl(wikitty);
                result.put(node, count);
            }
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't restore children", eee);
        }
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UpdateResponse syncEngin(final String securityToken) {
        final WikittyTransaction transaction = new WikittyTransaction();
        try {
            int numberForCommit = 1000;
            final WikittySearchEngin searchEngin = this.getSearchEngin();
            final UpdateResponse result = new UpdateResponse();
            final ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(1000);
            transaction.begin();
            searchEngin.clear(transaction);
            transaction.commit();
            transaction.begin();
            this.getWikittyStorage().scanWikitties(transaction, new WikittyStorage.Scanner(){
                int count = 0;

                @Override
                public void scan(String wikittyId) {
                    Wikitty wikitty = WikittyServiceImpl.this.restore(securityToken, transaction, wikittyId);
                    Date deleteDate = wikitty.getDeleteDate();
                    if (deleteDate == null) {
                        ++this.count;
                        wikitties.add(wikitty);
                        if (this.count == 1000) {
                            UpdateResponse response = searchEngin.store(transaction, wikitties);
                            result.add(response);
                            transaction.commit();
                            this.count = 0;
                            wikitties.clear();
                            transaction.begin();
                        }
                    }
                }
            });
            UpdateResponse response = searchEngin.store(transaction, wikitties);
            result.add(response);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException("Can't sync searchable index with data", eee);
        }
    }
}

