/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.util.Iterator;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.webharvest.gui.TreeNodeInfo;

public class PropertiesGridModel
extends AbstractTableModel
implements TableModelListener {
    private Object[][] properties;
    private TreeNodeInfo nodeInfo;

    public PropertiesGridModel() {
        this.addTableModelListener(this);
    }

    public Class getColumnClass(int columnIndex) {
        return columnIndex == 0 ? String.class : Object.class;
    }

    @Override
    public int getRowCount() {
        return this.properties == null ? 0 : this.properties.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int i) {
        if (i == 0) {
            return "Name";
        }
        if (i == 1) {
            return "Value";
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int i, int j) {
        return j >= 1;
    }

    @Override
    public Object getValueAt(int i, int j) {
        return j <= 1 ? this.properties[i][j] : null;
    }

    @Override
    public void tableChanged(TableModelEvent tablemodelevent) {
    }

    public void setProperties(Map properties, TreeNodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
        if (properties != null) {
            this.properties = new Object[properties.size()][2];
            Iterator iterator = properties.entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.properties[index][0] = entry.getKey();
                this.properties[index][1] = entry.getValue();
                ++index;
            }
        } else {
            this.properties = null;
        }
        this.fireTableDataChanged();
    }

    public TreeNodeInfo getNodeInfo() {
        return this.nodeInfo;
    }
}

