/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.util.Vector;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.v2.SimpleParameterList;

class V2Query
implements Query {
    private static final ParameterList NO_PARAMETERS = new SimpleParameterList(0, false);
    private final String[] fragments;
    private final boolean useEStringSyntax;

    V2Query(String query, boolean withParameters, ProtocolConnection pconn) {
        int i;
        this.useEStringSyntax = pconn.getServerVersion() != null && pconn.getServerVersion().compareTo("8.1") > 0;
        boolean stdStrings = pconn.getStandardConformingStrings();
        if (!withParameters) {
            this.fragments = new String[]{query};
            return;
        }
        Vector<String> v = new Vector<String>();
        int lastParmEnd = 0;
        char[] aChars = query.toCharArray();
        block8: for (i = 0; i < aChars.length; ++i) {
            switch (aChars[i]) {
                case '\'': {
                    i = Parser.parseSingleQuotes(aChars, i, stdStrings);
                    continue block8;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(aChars, i);
                    continue block8;
                }
                case '-': {
                    i = Parser.parseLineComment(aChars, i);
                    continue block8;
                }
                case '/': {
                    i = Parser.parseBlockComment(aChars, i);
                    continue block8;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(aChars, i);
                    continue block8;
                }
                case '?': {
                    v.addElement(query.substring(lastParmEnd, i));
                    lastParmEnd = i + 1;
                    continue block8;
                }
            }
        }
        v.addElement(query.substring(lastParmEnd, query.length()));
        this.fragments = new String[v.size()];
        for (i = 0; i < this.fragments.length; ++i) {
            this.fragments[i] = (String)v.elementAt(i);
        }
    }

    @Override
    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1, this.useEStringSyntax);
    }

    @Override
    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        for (int i = 1; i < this.fragments.length; ++i) {
            if (parameters == null) {
                sbuf.append("?");
            } else {
                sbuf.append(parameters.toString(i));
            }
            sbuf.append(this.fragments[i]);
        }
        return sbuf.toString();
    }

    @Override
    public void close() {
    }

    String[] getFragments() {
        return this.fragments;
    }
}

