/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public final class XSLCopyOf
extends StyleElement {
    private Expression select;
    private boolean copyNamespaces;
    private int validation = 3;
    private SchemaType schemaType;
    private boolean readOnce = false;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string6 = this.getNamePool().getClarkName(n);
            if (string6 == "select") {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (string6 == "copy-namespaces") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "validation") {
                string3 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "type") {
                string4 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "{http://saxon.sf.net/}read-once") {
                string5 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        } else {
            this.reportAbsence("select");
        }
        if (string2 == null) {
            this.copyNamespaces = true;
        } else if (string2.equals("yes")) {
            this.copyNamespaces = true;
        } else if (string2.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'", "XTSE0020");
        }
        if (string3 != null) {
            this.validation = Validation.getCode(string3);
            if (this.validation != 4 && !this.getConfiguration().isSchemaAware(50)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validation == -1) {
                this.compileError("invalid value of validation attribute", "XTSE0020");
            }
        } else {
            this.validation = this.getContainingStylesheet().getDefaultValidation();
        }
        if (string4 != null) {
            this.schemaType = this.getSchemaType(string4);
            if (!this.getConfiguration().isSchemaAware(50)) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
        }
        if (string4 != null && string3 != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (this.validation == 3 && !this.copyNamespaces) {
            this.compileError("copy-namespaces must be set to 'yes' when validation is set to 'preserve'", "XTSE0950");
        }
        if (string5 != null) {
            if (string5.equals("yes")) {
                this.readOnce = true;
            } else if (string5.equals("no")) {
                this.readOnce = false;
            } else {
                this.compileError("saxon:read-once attribute must be 'yes' or 'no'");
            }
        }
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable executable) {
        CopyOf copyOf = new CopyOf(this.select, this.copyNamespaces, this.validation, this.schemaType, false);
        if (this.readOnce) {
            copyOf.setReadOnce(this.readOnce);
        }
        ExpressionTool.makeParentReferences(copyOf);
        return copyOf;
    }
}

