/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiCartographyDTO;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import com.jurismarches.vradi.services.managers.BindingManager;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.services.managers.ImportExportManager;
import com.jurismarches.vradi.services.managers.PropertiesManager;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Search;

public class VradiStorageServiceImpl
implements VradiStorageService {
    private static final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);
    protected WikittyProxy proxy = ServiceFactory.getWikittyProxy();
    protected ThesaurusManager thesaurusManager = new ThesaurusManager(this.proxy);
    protected BindingManager bindingManager;
    protected FormManager formManager;
    protected FormTypeManager formTypeManager;
    protected ClientManager clientManager = new ClientManager(this.proxy);
    protected SearchManager searchManager;
    protected ImportExportManager importExportManager;

    public VradiStorageServiceImpl() {
        this.formTypeManager = new FormTypeManager(this.proxy);
        this.searchManager = new SearchManager(this.proxy, this.thesaurusManager);
        this.formManager = new FormManager(this.proxy, this.thesaurusManager, this.searchManager);
        this.bindingManager = new BindingManager(this.proxy, this.formTypeManager, this.formManager);
        this.importExportManager = new ImportExportManager(this.proxy);
        try {
            String[] config = PropertiesManager.getXmlStreamConfig();
            String intervalUnit = config[0];
            if (intervalUnit != null) {
                Integer intervalValue = config[1] == null ? null : Integer.valueOf(config[1]);
                Integer hour = config[2] == null ? null : Integer.valueOf(config[2]);
                Integer minute = config[3] == null ? null : Integer.valueOf(config[3]);
                this.autoLoadFormsFromXmlStreams(intervalUnit, intervalValue, hour, minute);
            } else {
                this.autoLoadFormsFromXmlStreams(VradiConstants.XmlStreamConfig.DAYS.toString(), 1, 0, 0);
            }
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <E extends BusinessEntity> E getEntity(String id, Class<E> clazz) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEntity(" + id + ", " + clazz.getSimpleName() + ")"));
        }
        BusinessEntity entity = this.proxy.restore(clazz, id);
        return (E)entity;
    }

    @Override
    public <E extends BusinessEntity> List<E> getEntities(List<String> ids, Class<E> clazz) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEntities(" + clazz.getSimpleName() + ")"));
        }
        List entity = this.proxy.restore(clazz, ids);
        return entity;
    }

    @Override
    public <E extends BusinessEntity> E updateEntity(E entity) throws VradiException {
        if (entity == null) {
            return entity;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateEntity(id:" + entity.getWikittyId() + "; version:" + entity.getWikittyVersion() + ")"));
        }
        try {
            if (QueryMaker.class.isAssignableFrom(entity.getClass())) {
                this.archiveQueries((QueryMaker)entity);
            }
            entity = this.proxy.store(entity);
            if (log.isDebugEnabled()) {
                log.debug((Object)("updateEntity(id:" + entity.getWikittyId() + "; version:" + entity.getWikittyVersion() + ")"));
            }
            return entity;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    @Override
    public <E extends BusinessEntity> E[] updateEntities(E ... entities) throws VradiException {
        List<E> list = Arrays.asList(entities);
        list = this.updateEntities(list);
        return (BusinessEntity[])list.toArray(entities);
    }

    @Override
    public <E extends BusinessEntity> List<E> updateEntities(List<E> entities) throws VradiException {
        if (entities == null || entities.size() == 0) {
            return entities;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateEntities(entities)");
            }
            for (BusinessEntity entity : entities) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("updateEntities(id:" + entity.getWikittyId() + "; version:" + entity.getWikittyVersion() + ")"));
                }
                if (!QueryMaker.class.isAssignableFrom(entity.getClass())) continue;
                this.archiveQueries((QueryMaker)entity);
            }
            entities = this.proxy.store(entities);
            return entities;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    @Override
    public void deleteEntity(String id) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deleteEntity(entity)");
        }
        if (id != null && !id.isEmpty()) {
            try {
                this.proxy.delete(id);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new VradiException(e);
            }
        }
    }

    @Override
    public void deleteEntity(BusinessEntity entity) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deleteEntity(entity)");
        }
        if (entity != null) {
            try {
                this.proxy.delete(entity.getWikittyId());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new VradiException(e);
            }
        }
    }

    @Override
    public User getUser(String userId) throws VradiException {
        return this.clientManager.getUser(userId);
    }

    @Override
    public Client getClient(String clientId) throws VradiException {
        return this.clientManager.getClient(clientId);
    }

    @Override
    public Group getGroup(String groupId) throws VradiException {
        return this.clientManager.getGroup(groupId);
    }

    @Override
    public String getQueryHistoryFile(String id) {
        return this.clientManager.getQueryHistoryFile(id);
    }

    @Override
    public List<User> getGroupUsers(String groupId) throws VradiException {
        return this.clientManager.getGroupUsers(groupId);
    }

    @Override
    @Deprecated
    public List<User> getClientUsers(String clientId) throws VradiException {
        return this.clientManager.getClientUsers(clientId);
    }

    @Override
    public List<Client> getGroupClients(String groupId) throws VradiException {
        return this.clientManager.getGroupClients(groupId);
    }

    @Override
    public Client getClientByUserId(String userId) throws VradiException {
        return this.clientManager.getClientByUserId(userId);
    }

    @Override
    public List<Client> getAllClients() throws VradiException {
        return this.clientManager.getAllClients();
    }

    @Override
    public List<User> getAllUsers() throws VradiException {
        return this.clientManager.getAllUsers();
    }

    @Override
    public List<VradiUserDTO> getAllUserDTOs() throws VradiException {
        return this.clientManager.getAllUserDTOs();
    }

    @Override
    public List<Group> getAllGroups() throws VradiException {
        return this.clientManager.getAllGroups();
    }

    @Override
    public Form updateForm(Form form) throws VradiException {
        return this.formManager.updateForm(form);
    }

    @Override
    public List<Form> updateForms(List<Form> forms) throws VradiException {
        return this.formManager.updateForms(forms);
    }

    @Override
    public VradiFormPageDTO findForms(String query, VradiFormPageDTO formPageDTO) throws UnsupportedQueryException {
        return this.findForms2(query, null, null, null, null, null, null, formPageDTO);
    }

    @Override
    public VradiFormPageDTO findForms2(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, String[] statusIds, VradiFormPageDTO formPageDTO) throws UnsupportedQueryException {
        VradiFormPageDTO result = this.searchManager.findForms(query, extension, dateType, beginDate, endDate, thesaurus, statusIds, formPageDTO);
        return result;
    }

    @Override
    public VradiCartographyDTO getThesaurusCartography(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, String[] statusIds) throws VradiException, UnsupportedQueryException {
        VradiCartographyDTO cartography = this.searchManager.getThesaurusCartography(query, extension, dateType, beginDate, endDate, thesaurus, statusIds);
        return cartography;
    }

    @Override
    public Map<QueryMaker, List<VradiQueryBean>> findQueriesReturningForm(Form form) throws VradiException {
        return this.searchManager.findQueriesReturningForm(form);
    }

    @Override
    public List<WikittyExtension> getAllFormTypes() {
        return this.formTypeManager.getAllFormTypes();
    }

    @Override
    public WikittyExtension getFormType(String name) throws VradiException {
        return this.formTypeManager.getFormType(name);
    }

    @Override
    public Map<String, FieldType> getFormTypeFields(String name) throws VradiException {
        return this.formTypeManager.getFormTypeFields(name);
    }

    @Override
    public WikittyExtension updateFormType2(String name, Map<String, FieldType> fields, String requires, Map<String, String> tagValues) throws VradiException {
        return this.formTypeManager.updateFormType(name, fields, requires, tagValues);
    }

    @Override
    public WikittyExtension updateFormType(WikittyExtension extension) throws VradiException {
        return this.formTypeManager.updateFormType(extension);
    }

    @Override
    public Form getForm(String formId) {
        return this.formManager.getForm(formId);
    }

    @Override
    public void deleteForm(String formId) {
        this.formManager.deleteForm(formId);
    }

    @Override
    public List<Form> getForms(List<String> formIds) {
        return this.formManager.getForms(formIds);
    }

    @Override
    public List<Form> getAllForms() {
        return this.formManager.getAllForms();
    }

    @Override
    public List<XmlStream> getAllXmlStreams() {
        return this.bindingManager.getAllXmlStreams();
    }

    @Override
    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) throws VradiException {
        return this.bindingManager.updateXmlFieldBindings(bindings);
    }

    @Override
    public XmlStream updateXmlStream(XmlStream xmlStream, List<XmlFieldBinding> bindings) throws VradiException {
        return this.bindingManager.updateXmlStream(xmlStream, bindings);
    }

    @Override
    public XmlStream getXmlStream(String xmlStreamId) throws VradiException {
        return this.bindingManager.getXmlStream(xmlStreamId);
    }

    @Override
    public XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) {
        return this.bindingManager.getXmlFieldBinding(xmlFieldBindingId);
    }

    @Override
    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) {
        return this.bindingManager.getXmlFieldBindings(xmlStream);
    }

    @Override
    public void bindForms() throws VradiException {
        this.formManager.bindForms();
    }

    @Override
    public List<Sending> createSending(Session session, QueryMaker queryMaker, List<Form> formsToBind) throws VradiException {
        return this.formManager.createAllSending(session, queryMaker, formsToBind, false);
    }

    @Override
    public List<Sending> removeAllSending(Session session, Form form, QueryMaker queryMaker) throws VradiException {
        return this.formManager.removeAllSending(session, form, queryMaker);
    }

    @Override
    public List<Session> getSessions(Date sessionDate) throws VradiException {
        return this.formManager.getSessions(sessionDate);
    }

    @Override
    public int[] getFormsFromXmlStream(XmlStream xmlStream, VradiUser vradiUser) throws VradiException {
        return this.bindingManager.getFormsFromXmlStream(xmlStream, vradiUser);
    }

    @Override
    public VradiUser updateVradiUser(VradiUser vradiUser) throws VradiException {
        Search search;
        Criteria criteria;
        PagedResult users;
        List result;
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateVradiUser(vradiUser)");
        }
        if ((result = (users = this.proxy.findAllByCriteria(VradiUser.class, criteria = (search = Search.query().eq("VradiUser.name", vradiUser.getName())).criteria())).getAll()).size() > 0) {
            log.debug((Object)("user " + vradiUser + " already exists"));
            return null;
        }
        return (VradiUser)this.proxy.store((BusinessEntity)vradiUser);
    }

    @Override
    public VradiUser logVradiUser(String vradiUserName, String vradiUserPassword) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("logVradiUser(" + vradiUserName + ", " + vradiUserPassword + ")"));
        }
        Criteria criteria = Search.query().eq("VradiUser.name", vradiUserName).eq("VradiUser.password", vradiUserPassword).criteria();
        VradiUser vradiUser = (VradiUser)this.proxy.findByCriteria(VradiUser.class, criteria);
        return vradiUser;
    }

    @Override
    public void updateSendings(List<Sending> sendings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateSendings(sendings)");
        }
        this.proxy.store(sendings);
    }

    @Override
    public void importData(File file) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"importData(file)");
        }
        String toURI = file.toURI().toString();
        log.info((Object)("importing file: " + toURI));
        this.proxy.syncImportFromUri(toURI);
        log.info((Object)"import done");
    }

    @Override
    public String exportData() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"exportData()");
        }
        log.info((Object)"exporting all data");
        try {
            Search search = Search.query().keyword("*");
            Criteria criteria = search.criteria();
            String export = this.proxy.syncExportAllByCriteria(criteria);
            log.info((Object)"export done");
            return export;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    @Override
    public void importAsCSV(String uri) throws VradiException {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Importing data as CSV with url = " + uri));
            }
            try {
                this.importExportManager.syncImportFromCSVUri(uri);
            }
            catch (WikittyException eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't import data", (Throwable)eee);
            }
        }
    }

    @Override
    public String exportAsCSV(Criteria criteria) throws VradiException {
        String result;
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exporting data as CSV with criteria " + criteria));
            }
            result = null;
            try {
                result = this.importExportManager.syncExportCSVAllByCriteria(criteria);
            }
            catch (WikittyException eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't export data", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public void reindexData() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"reindexData()");
        }
        UpdateResponse response = this.proxy.getWikittyService().syncEngin();
        if (log.isDebugEnabled()) {
            log.debug((Object)response.toString());
        }
    }

    @Override
    public TreeNodeImpl getRootThesaurus() throws VradiException {
        return this.thesaurusManager.getRootThesaurus();
    }

    @Override
    public List<TreeNodeImpl> getAllThesaurus() throws VradiException {
        return this.thesaurusManager.getAllThesaurus();
    }

    @Override
    public TreeNodeImpl getThesaurus(String thesaurusId) throws VradiException {
        return this.thesaurusManager.getThesaurus(thesaurusId);
    }

    @Override
    public List<TreeNodeImpl> getChildrenThesaurus(String thesaurusId) throws VradiException {
        return this.thesaurusManager.getChildrenThesaurus(thesaurusId);
    }

    @Override
    public int getNbFormsForThesaurus(String thesaurusId) throws VradiException {
        return this.thesaurusManager.getNbFormsForThesaurus(thesaurusId);
    }

    @Override
    public Status getStatus(String statusId) throws VradiException {
        return this.formManager.getStatus(statusId);
    }

    @Override
    public List<Status> getStatuses(List<String> statusIds) throws VradiException {
        return this.formManager.getStatuses(statusIds);
    }

    @Override
    public List<Status> getAllStatuses() throws VradiException {
        return this.formManager.getAllStatuses();
    }

    @Override
    public Status updateStatus(Status status) throws VradiException {
        return this.formManager.updateStatus(status);
    }

    @Override
    public List<Status> updateStatuses(List<Status> statuses) throws VradiException {
        return this.formManager.updateStatuses(statuses);
    }

    @Override
    public void deleteStatus(String statusId) throws VradiException {
        List<String> statusIds = Arrays.asList(statusId);
        this.formManager.deleteStatuses(statusIds);
    }

    @Override
    public void deleteStatuses(List<String> statusIds) throws VradiException {
        this.formManager.deleteStatuses(statusIds);
    }

    @Override
    public List<TreeNodeImpl> proposeThesaurus(Form form, List<TreeNodeImpl> thesaurus) throws VradiException {
        return this.thesaurusManager.proposeThesaurus(form, thesaurus);
    }

    @Override
    public void archiveQueries(QueryMaker queryMaker) throws VradiException {
        this.clientManager.archiveQueries(queryMaker);
    }

    @Override
    public void autoLoadFormsFromXmlStreams(String intervalUnit, int intervalValue, Integer hour, Integer minute) throws VradiException {
        this.bindingManager.autoLoadFormsFromXmlStreams(intervalUnit, intervalValue, hour, minute);
    }

    @Override
    public void uploadFiles(Form form, List<File> files) throws IOException {
        this.formManager.uploadFiles(form, files);
    }

    @Override
    public void uploadAttachments(Form form, List<File> attachments) throws IOException {
        this.formManager.uploadAttachments(form, attachments);
    }

    @Override
    public File addTemplate(WikittyExtension extension, File template) throws VradiException {
        return this.formTypeManager.addTemplate(extension, template);
    }

    @Override
    public File[] getTemplates(WikittyExtension extension) {
        return this.formTypeManager.getTemplates(extension);
    }

    @Override
    public File getTemplate(String extensionName, String templateName) {
        return this.formTypeManager.getTemplate(extensionName, templateName);
    }

    @Override
    public void setAssociatedFields(String extensionName, String templateName, Map<String, String> fieldMap) throws VradiException, IOException {
        this.formTypeManager.setAssociatedFields(extensionName, templateName, fieldMap);
    }

    @Override
    public Map<String, String> getAssociatedFields(String extensionName, String templateName) throws VradiException {
        return this.formTypeManager.getAssociatedFields(extensionName, templateName);
    }

    @Override
    public Map<QueryMaker, List<VradiQueryBean>> getQueriesToModifyAfterThesaurusModification(String thesaurusName) {
        return this.thesaurusManager.getQueriesToModifyAfterThesaurusModification(thesaurusName);
    }
}

