/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.*;

import com.jurismarches.vradi.entities.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:33:15
 */
public class VradiSendingDTO  extends SendingBean implements VradiDTO<Sending> {

    private static final long serialVersionUID = 1L;

    protected static Log log = LogFactory.getLog(VradiSendingDTO.class);

    protected transient PropertyChangeSupport propertyChange =
            new PropertyChangeSupport(this);

    // DTOs
    protected VradiUserDTO userDTO = null;
    protected VradiClientDTO clientDTO = null;
    protected VradiGroupDTO groupDTO = null;
    protected List<VradiFormDTO> formDTOs;
    protected VradiSessionDTO session;

    public VradiSendingDTO() {
        Sending$form = new HashSet<String>();
        Sending$deletedForms = new HashSet<String>();
        formDTOs = new ArrayList<VradiFormDTO>();
    }

    @Override
    public void fromWikitty(Sending wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setParagraph(wikitty.getParagraph());
            setReceptionProof(wikitty.getReceptionProof());
            setStatus(wikitty.getStatus());
            setReceptionDate(wikitty.getReceptionDate());
            setSentDate(wikitty.getSentDate());
            setClient(wikitty.getClient());
            setUser(wikitty.getUser());
            setGroup(wikitty.getGroup());
            Set<String> formsIds = wikitty.getForm();
            if (formsIds != null){
                for (String f : formsIds){
                    addForm(f);
                }
            }
            Set<String> deletedFormsIds = wikitty.getDeletedForms();
            if (deletedFormsIds != null){
                for (String f : deletedFormsIds){
                    addDeletedForms(f);
                }
            }
        }
    }

    @Override
    public void toWikitty(Sending wikitty) {
        wikitty.setParagraph(getParagraph());
        wikitty.setReceptionProof(getReceptionProof());
        wikitty.setStatus(getStatus());
        wikitty.setReceptionDate(getReceptionDate());
        wikitty.setSentDate(getSentDate());
        wikitty.setUser(getUser());
        wikitty.setClient(getClient());
        wikitty.setGroup(getGroup());
        Set<String> formsIds = getForm();
        if (formsIds != null){
            for (String f : formsIds){
                wikitty.addForm(f);
            }
        }
        Set<String> deletedFormsIds = getDeletedForms();
        if (deletedFormsIds != null){
            for (String f : deletedFormsIds){
                wikitty.addDeletedForms(f);
            }
        }
    }

    @Override
    public void reset() {
        setParagraph(null);
        setReceptionProof(false);
        setStatus(0);
        setReceptionDate(null);
        setSentDate(null);
        setClient(null);
        setUser(null);
        setGroup(null);
        clearForm();
        clearDeletedForms();
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName,
                                          PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName,
                                             PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(propertyName, listener);
    }

    public List<VradiFormDTO> getFormDTOs() {
        return formDTOs;
    }

    public void addFormDTO(Form form) {
        if (form != null) {
            List<VradiFormDTO> oldValue = formDTOs;
            if (formDTOs == null){
                formDTOs = new ArrayList<VradiFormDTO>();
            }
            addForm(form.getWikittyId());
            VradiFormDTO formDTO = new VradiFormDTO();
            formDTO.fromWikitty(form);
            this.formDTOs.add(formDTO);
            propertyChange.firePropertyChange("formDTOs", oldValue, formDTOs);
        }
    }

    public void setFormDTOs(List<VradiFormDTO> formDTOs) {
        if (formDTOs != null) {
            List<VradiFormDTO> oldValue = formDTOs;
            this.formDTOs = formDTOs;
            propertyChange.firePropertyChange("formDTOs", oldValue, formDTOs);
        }
    }

    public void removeFormDTO(VradiFormDTO form) {
        if (form != null) {
            formDTOs.remove(form);
            removeForm(form.getWikittyId());
        }
    }

    @Override
    public void setSentDate(Date value) {
        Date oldValue = getSentDate();
        super.setSentDate(value);
        propertyChange.firePropertyChange("sentDate", oldValue, value);
    }

    @Override
    public Date getSentDate() {
        return super.getSentDate();
    }

    @Override
    public void setReceptionDate(Date value) {
        Date oldValue = getReceptionDate();
        super.setReceptionDate(value);
        propertyChange.firePropertyChange("receptionDate", oldValue, value);
    }

    @Override
    public Date getReceptionDate() {
        return super.getReceptionDate();
    }

    @Override
    public void setParagraph(String value) {
        String oldValue = getParagraph();
        super.setParagraph(value);
        propertyChange.firePropertyChange("paragraph", oldValue, value);
    }

    @Override
    public String getParagraph() {
        return super.getParagraph();
    }

    @Override
    public void setReceptionProof(boolean value) {
        boolean oldValue = getReceptionProof();
        super.setReceptionProof(value);
        propertyChange.firePropertyChange("receptionProof", oldValue, value);
    }

    @Override
    public boolean getReceptionProof() {
        return super.getReceptionProof();
    }

    @Override
    public void setStatus(int value) {
        int oldValue = getStatus();
        super.setStatus(value);
        propertyChange.firePropertyChange("status", oldValue, value);
    }

    @Override
    public int getStatus() {
        return super.getStatus();
    }

    public <E extends QueryMaker> void setQueryMakerDTO(E queryMaker) {
        if (queryMaker instanceof VradiClientDTO){
            setClientDTO((VradiClientDTO) queryMaker);
        }
        else if (queryMaker instanceof VradiUserDTO){
            setUserDTO((VradiUserDTO)queryMaker);
        }
        else if (queryMaker instanceof VradiGroupDTO){
            setGroupDTO((VradiGroupDTO)queryMaker);
        }
    }

    public QueryMaker getQueryMakerDTO() {
        if (getClientDTO() != null){
            return getClientDTO();
        }
        if (getUserDTO() != null){
            return getUserDTO();
        }
        if (getGroupDTO() != null){
            return getGroupDTO();
        }
        return null;
    }

    public VradiUserDTO getUserDTO() {
        return userDTO;
    }

    public void setUserDTO(VradiUserDTO userDTO) {
        VradiUserDTO oldValue = this.userDTO;
        this.userDTO = userDTO;
        propertyChange.firePropertyChange("userDTO", oldValue, userDTO);
    }

    public VradiClientDTO getClientDTO() {
        return clientDTO;
    }

    public void setClientDTO(VradiClientDTO clientDTO) {
        VradiClientDTO oldValue = this.clientDTO;
        this.clientDTO = clientDTO;
        propertyChange.firePropertyChange("clientDTO", oldValue, clientDTO);
    }

    public VradiGroupDTO getGroupDTO() {
        return groupDTO;
    }

    public void setGroupDTO(VradiGroupDTO groupDTO) {
        VradiGroupDTO oldValue = this.groupDTO;
        this.groupDTO = groupDTO;
        propertyChange.firePropertyChange("groupDTO", oldValue, groupDTO);
    }

    public void setSessionDTO(VradiSessionDTO session) {
        this.session = session;
    }

    public VradiSessionDTO getSessionDTO() {
        return session;
    }
}
