/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyTreeNode;
import org.nuiton.wikitty.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.WikittyTreeNodeImpl;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public interface Thesaurus extends BusinessEntity, WikittyTreeNode {     String EXT_THESAURUS = "Thesaurus";
     String FIELD_THESAURUS_TAGS = "tags";
     String FQ_FIELD_THESAURUS_TAGS = EXT_THESAURUS + ".tags";
     String FIELD_THESAURUS_ORDER = "order";
     String FQ_FIELD_THESAURUS_ORDER = EXT_THESAURUS + ".order";
     String FIELD_THESAURUS_COMMENT = "comment";
     String FQ_FIELD_THESAURUS_COMMENT = EXT_THESAURUS + ".comment";
     String FIELD_THESAURUS_ROOTTHESAURUS = "rootThesaurus";
     String FQ_FIELD_THESAURUS_ROOTTHESAURUS = EXT_THESAURUS + ".rootThesaurus";
    /**
     * getTags :
     * @return Set<String> 
     */

     Set<String> getTags();

    /**
     * addTags :
     * @param element 
     */

     void addTags(String element);

    /**
     * removeTags :
     * @param element 
     */

     void removeTags(String element);

    /**
     * clearTags :
     */

     void clearTags();

    /**
     * getOrder :
     * @return int 
     */

     int getOrder();

    /**
     * setOrder :
     * @param order 
     */

     void setOrder(int order);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * setComment :
     * @param comment 
     */

     void setComment(String comment);

    /**
     * getRootThesaurus :
     * Root thesaurus wikitty id.
     * @return String 
     */

     String getRootThesaurus();

    /**
     * setRootThesaurus :
     * @param rootThesaurus 
     */

     void setRootThesaurus(String rootThesaurus);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setName :
     * @param name 
     */

     void setName(String name);

    /**
     * getAttachment :
     * @return Set<String> 
     */

     Set<String> getAttachment();

    /**
     * addAttachment :
     * @param element 
     */

     void addAttachment(String element);

    /**
     * removeAttachment :
     * @param element 
     */

     void removeAttachment(String element);

    /**
     * clearAttachment :
     */

     void clearAttachment();

    /**
     * getParent :
     * @return String 
     */

     String getParent();

    /**
     * setParent :
     * @param parent 
     */

     void setParent(String parent);


} //Thesaurus
