/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class SendingAbstract extends BusinessEntityWikitty implements Sending {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionSending;
    /**
     * getSentDate :
     * @return Date 
     */

    @Override
    public Date getSentDate() {
        Date value = SendingHelper.getSentDate(getWikitty());
        return value;
}

    /**
     * setSentDate :
     * @param sentDate 
     */

    @Override
    public void setSentDate(Date sentDate) {
        Date oldValue = getSentDate();
        SendingHelper.setSentDate(getWikitty(), sentDate);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_SENTDATE, oldValue, getSentDate());
}

    /**
     * getReceptionDate :
     * @return Date 
     */

    @Override
    public Date getReceptionDate() {
        Date value = SendingHelper.getReceptionDate(getWikitty());
        return value;
}

    /**
     * setReceptionDate :
     * @param receptionDate 
     */

    @Override
    public void setReceptionDate(Date receptionDate) {
        Date oldValue = getReceptionDate();
        SendingHelper.setReceptionDate(getWikitty(), receptionDate);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_RECEPTIONDATE, oldValue, getReceptionDate());
}

    /**
     * getParagraph :
     * @return String 
     */

    @Override
    public String getParagraph() {
        String value = SendingHelper.getParagraph(getWikitty());
        return value;
}

    /**
     * setParagraph :
     * @param paragraph 
     */

    @Override
    public void setParagraph(String paragraph) {
        String oldValue = getParagraph();
        SendingHelper.setParagraph(getWikitty(), paragraph);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_PARAGRAPH, oldValue, getParagraph());
}

    /**
     * getReceptionProof :
     * @return boolean 
     */

    @Override
    public boolean getReceptionProof() {
        boolean value = SendingHelper.getReceptionProof(getWikitty());
        return value;
}

    /**
     * setReceptionProof :
     * @param receptionProof 
     */

    @Override
    public void setReceptionProof(boolean receptionProof) {
        boolean oldValue = getReceptionProof();
        SendingHelper.setReceptionProof(getWikitty(), receptionProof);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_RECEPTIONPROOF, oldValue, getReceptionProof());
}

    /**
     * getStatus :
     * @return int 
     */

    @Override
    public int getStatus() {
        int value = SendingHelper.getStatus(getWikitty());
        return value;
}

    /**
     * setStatus :
     * @param status 
     */

    @Override
    public void setStatus(int status) {
        int oldValue = getStatus();
        SendingHelper.setStatus(getWikitty(), status);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_STATUS, oldValue, getStatus());
}

    /**
     * getMessageId :
     * @return String 
     */

    @Override
    public String getMessageId() {
        String value = SendingHelper.getMessageId(getWikitty());
        return value;
}

    /**
     * setMessageId :
     * @param messageId 
     */

    @Override
    public void setMessageId(String messageId) {
        String oldValue = getMessageId();
        SendingHelper.setMessageId(getWikitty(), messageId);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_MESSAGEID, oldValue, getMessageId());
}

    /**
     * getForm :
     * @return Set<String> 
     */

    @Override
    public Set<String> getForm() {
        Set<String> result = SendingHelper.getForm(getWikitty());
        return result;
}

    /**
     * addForm :
     * @param element 
     */

    @Override
    public void addForm(String element) {
        SendingHelper.addForm(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_FORM, null, getForm());
}

    /**
     * removeForm :
     * @param element 
     */

    @Override
    public void removeForm(String element) {
        SendingHelper.removeForm(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_FORM, null, getForm());
}

    /**
     * clearForm :
     */

    @Override
    public void clearForm() {
        SendingHelper.clearForm(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_FORM, null, getForm());
}

    /**
     * getUser :
     * @return String 
     */

    @Override
    public String getUser() {
        String value = SendingHelper.getUser(getWikitty());
        return value;
}

    /**
     * setUser :
     * @param user 
     */

    @Override
    public void setUser(String user) {
        String oldValue = getUser();
        SendingHelper.setUser(getWikitty(), user);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_USER, oldValue, getUser());
}

    /**
     * getDeletedForms :
     * @return Set<String> 
     */

    @Override
    public Set<String> getDeletedForms() {
        Set<String> result = SendingHelper.getDeletedForms(getWikitty());
        return result;
}

    /**
     * addDeletedForms :
     * @param element 
     */

    @Override
    public void addDeletedForms(String element) {
        SendingHelper.addDeletedForms(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_DELETEDFORMS, null, getDeletedForms());
}

    /**
     * removeDeletedForms :
     * @param element 
     */

    @Override
    public void removeDeletedForms(String element) {
        SendingHelper.removeDeletedForms(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_DELETEDFORMS, null, getDeletedForms());
}

    /**
     * clearDeletedForms :
     */

    @Override
    public void clearDeletedForms() {
        SendingHelper.clearDeletedForms(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_DELETEDFORMS, null, getDeletedForms());
}

    /**
     * SendingAbstract :
     */

    public SendingAbstract() {
        super();
}

    /**
     * SendingAbstract :
     * @param wikitty 
     */

    public SendingAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * SendingAbstract :
     * @param businessEntityWikitty 
     */

    public SendingAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionSending =
                new WikittyExtension(EXT_SENDING,
                                     "4.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Date sentDate unique=true", 
                                             "Date receptionDate unique=true", 
                                             "String paragraph unique=true", 
                                             "boolean receptionProof unique=true", 
                                             "Numeric status unique=true", 
                                             "String messageId unique=true", 
                                             "Wikitty form[0-*] unique=true", 
                                             "Wikitty user unique=true", 
                                             "Wikitty deletedForms[0-*] unique=true"));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionSending);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //SendingAbstract
