package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;

/**
 * Vradi user.
 * 
 * Changes :
 * * 2.0 : inheritance from wikittyuser
 * * 1.0 initial version
 */
public abstract class VradiUserAbstract extends WikittyUserImpl implements VradiUser, WikittyUser {

    private static final long serialVersionUID = 827378632L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionVradiUser =
        new WikittyExtension(EXT_VRADIUSER, "2.0", WikittyUser.EXT_WIKITTYUSER,
		    WikittyUtil.buildFieldMapExtension(
				"String email"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyUserAbstract.extensions);
        // current after requires ones
        exts.add(extensionVradiUser);

        extensions = Collections.unmodifiableList(exts);
    }

	public VradiUserAbstract() {
		super();
	}

    public VradiUserAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public VradiUserAbstract(Wikitty wi) {
		super(wi);
	}


    public void setEmail(String email) {
        Object oldValue = getField(EXT_VRADIUSER, FIELD_VRADIUSER_EMAIL);
        getWikitty().setField(EXT_VRADIUSER, FIELD_VRADIUSER_EMAIL, email);
        getPropertyChangeSupport().firePropertyChange(FIELD_VRADIUSER_EMAIL, oldValue, email);
    }

    public String getEmail() {
        String result = getWikitty().getFieldAsString(EXT_VRADIUSER, FIELD_VRADIUSER_EMAIL);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_VRADIUSER, FIELD_VRADIUSER_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_VRADIUSER, FIELD_VRADIUSER_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //VradiUserAbstract
