package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

/**
 * Thesaurus extension for {@link TreeNode}.
 *  
 * Changes in this extension :
 * <ul>
 *  <li>4.0 : ajout des contraintes notNull/unique
 *  <li>3.0 : add rootThesaurus : rootThesaurus reference
 *  <li>2.0 : add order field (numeric)
 *  <li>1.0 : intial version
 * </ul>
 */
public abstract class ThesaurusAbstract extends TreeNodeImpl implements Thesaurus, TreeNode {

    private static final long serialVersionUID = 1084227215L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionThesaurus =
        new WikittyExtension(EXT_THESAURUS, "4.0", TreeNode.EXT_TREENODE,
		    WikittyUtil.buildFieldMapExtension(
				"String tags[0-*] unique=true",
				"Numeric order",
				"String comment",
				"String rootThesaurus documentation=\"Root thesaurus wikitty id.\" notNull=\"true\""));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(TreeNodeAbstract.extensions);
        // current after requires ones
        exts.add(extensionThesaurus);

        extensions = Collections.unmodifiableList(exts);
    }

	public ThesaurusAbstract() {
		super();
	}

    public ThesaurusAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public ThesaurusAbstract(Wikitty wi) {
		super(wi);
	}

    public Set<String> getTags() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_THESAURUS, FIELD_THESAURUS_TAGS, String.class);
        return result;
    }

    public void addTags(String element) {
        getWikitty().addToField(EXT_THESAURUS, FIELD_THESAURUS_TAGS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_THESAURUS_TAGS, null, getTags());
    }
    
    public void removeTags(String element) {
        getWikitty().removeFromField(EXT_THESAURUS, FIELD_THESAURUS_TAGS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_THESAURUS_TAGS, null, getTags());
    }
    
    public void clearTags() {
        getWikitty().clearField(EXT_THESAURUS, FIELD_THESAURUS_TAGS);
        getPropertyChangeSupport().firePropertyChange(FIELD_THESAURUS_TAGS, null, getTags());
    }


    public void setOrder(int order) {
        Object oldValue = getField(EXT_THESAURUS, FIELD_THESAURUS_ORDER);
        getWikitty().setField(EXT_THESAURUS, FIELD_THESAURUS_ORDER, order);
        getPropertyChangeSupport().firePropertyChange(FIELD_THESAURUS_ORDER, oldValue, order);
    }

    public int getOrder() {
        int result = getWikitty().getFieldAsInt(EXT_THESAURUS, FIELD_THESAURUS_ORDER);
        return result;
    }


    public void setComment(String comment) {
        Object oldValue = getField(EXT_THESAURUS, FIELD_THESAURUS_COMMENT);
        getWikitty().setField(EXT_THESAURUS, FIELD_THESAURUS_COMMENT, comment);
        getPropertyChangeSupport().firePropertyChange(FIELD_THESAURUS_COMMENT, oldValue, comment);
    }

    public String getComment() {
        String result = getWikitty().getFieldAsString(EXT_THESAURUS, FIELD_THESAURUS_COMMENT);
        return result;
    }


    public void setRootThesaurus(String rootThesaurus) {
        Object oldValue = getField(EXT_THESAURUS, FIELD_THESAURUS_ROOTTHESAURUS);
        getWikitty().setField(EXT_THESAURUS, FIELD_THESAURUS_ROOTTHESAURUS, rootThesaurus);
        getPropertyChangeSupport().firePropertyChange(FIELD_THESAURUS_ROOTTHESAURUS, oldValue, rootThesaurus);
    }

    public String getRootThesaurus() {
        String result = getWikitty().getFieldAsString(EXT_THESAURUS, FIELD_THESAURUS_ROOTTHESAURUS);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_THESAURUS, FIELD_THESAURUS_TAGS);
            Object f2 = w2.getFieldAsObject(EXT_THESAURUS, FIELD_THESAURUS_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_THESAURUS, FIELD_THESAURUS_ORDER);
            Object f2 = w2.getFieldAsObject(EXT_THESAURUS, FIELD_THESAURUS_ORDER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_THESAURUS, FIELD_THESAURUS_COMMENT);
            Object f2 = w2.getFieldAsObject(EXT_THESAURUS, FIELD_THESAURUS_COMMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_THESAURUS, FIELD_THESAURUS_ROOTTHESAURUS);
            Object f2 = w2.getFieldAsObject(EXT_THESAURUS, FIELD_THESAURUS_ROOTTHESAURUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //ThesaurusAbstract
