package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class QueryMakerAbstract extends BusinessEntityWikitty implements QueryMaker {

    private static final long serialVersionUID = 1591779000L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionQueryMaker =
        new WikittyExtension(EXT_QUERYMAKER, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String queries[0-*] unique=true"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionQueryMaker);

        extensions = Collections.unmodifiableList(exts);
    }

	public QueryMakerAbstract() {
		super();
	}

    public QueryMakerAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public QueryMakerAbstract(Wikitty wi) {
		super(wi);
	}

    public Set<String> getQueries() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //QueryMakerAbstract
