package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class XmlStreamImpl extends BusinessEntityWikitty implements XmlStream {

    private static final long serialVersionUID = -672613865L;

    static final protected List<WikittyExtension> extensions;
    static final public WikittyExtension extensionXmlStream =
        new WikittyExtension(EXT_XMLSTREAM, "2.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String url unique",
				"String name unique",
				"String formTypeName unique",
				"Wikitty xmlFieldBinding[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        // EC-20100420 add current extension after parent ones
        // if current is loaded before required extension
        // load failed because required extension is missing
        exts.add(extensionXmlStream);

        extensions = Collections.unmodifiableList(exts);
    }

	public XmlStreamImpl() {
		super();
	}

    public XmlStreamImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public XmlStreamImpl(Wikitty wi) {
		super(wi);
	}


    public void setUrl(String url) {
        getWikitty().setField(EXT_XMLSTREAM, "url", url);
    }

    public String getUrl() {
        String result = getWikitty().getFieldAsString(EXT_XMLSTREAM, "url");
        return result;
    }


    public void setName(String name) {
        getWikitty().setField(EXT_XMLSTREAM, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_XMLSTREAM, "name");
        return result;
    }


    public void setFormTypeName(String formTypeName) {
        getWikitty().setField(EXT_XMLSTREAM, "formTypeName", formTypeName);
    }

    public String getFormTypeName() {
        String result = getWikitty().getFieldAsString(EXT_XMLSTREAM, "formTypeName");
        return result;
    }

    public Set<String> getXmlFieldBinding() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_XMLSTREAM, "xmlFieldBinding", String.class);
        return result;
    }

    public void addXmlFieldBinding(String element) {
        getWikitty().addToField(EXT_XMLSTREAM, "xmlFieldBinding", element);
    }
    
    public void removeXmlFieldBinding(String element) {
        getWikitty().removeFromField(EXT_XMLSTREAM, "xmlFieldBinding", element);
    }
    
    public void clearXmlFieldBinding() {
        getWikitty().clearField(EXT_XMLSTREAM, "xmlFieldBinding");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //XmlStreamImpl
