/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Rectangle2D;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ValuesConverter;

public class Rectangle2DConverter
extends ValuesConverter<Rectangle2D, Double> {
    public Rectangle2DConverter() {
        super("; ", Double.class);
    }

    public Rectangle2DConverter(String separator) {
        super(separator, Double.class);
    }

    @Override
    public String toString(Rectangle2D rectangle2d, ConverterContext context) {
        if (rectangle2d == null) {
            return null;
        }
        ArrayList<Double> list = new ArrayList<Double>(4);
        list.add(rectangle2d.getMinX());
        list.add(rectangle2d.getMinY());
        list.add(rectangle2d.getWidth());
        list.add(rectangle2d.getHeight());
        return this.valuesToString(list, context);
    }

    @Override
    public Rectangle2D fromString(String string, ConverterContext context) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        List objects = this.valuesFromString(string, context);
        double minX = 0.0;
        if (objects.size() >= 1) {
            Double value = (Double)objects.get(0);
            minX = value == null ? 0.0 : value;
        }
        double minY = 0.0;
        if (objects.size() >= 2) {
            Double value = (Double)objects.get(1);
            minY = value == null ? 0.0 : value;
        }
        double width = 0.0;
        if (objects.size() >= 3) {
            Double value = (Double)objects.get(2);
            width = value == null ? 0.0 : value;
        }
        double height = 0.0;
        if (objects.size() >= 4) {
            Double value = (Double)objects.get(3);
            height = value == null ? 0.0 : value;
        }
        return new Rectangle2D(minX, minY, width, height);
    }
}

