/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.util.Locale;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ConverterResource;
import jidefx.utils.converter.DefaultObjectConverter;

public class BooleanConverter
extends DefaultObjectConverter<Boolean> {
    @Override
    public String toString(Boolean object, ConverterContext context) {
        if (Boolean.FALSE.equals(object)) {
            return this.getFalse();
        }
        if (Boolean.TRUE.equals(object)) {
            return this.getTrue();
        }
        return this.getNull();
    }

    @Override
    public Boolean fromString(String string, ConverterContext context) {
        if (string.equalsIgnoreCase(this.getTrue())) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase(this.getFalse())) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected String getTrue() {
        String s = ConverterResource.getResourceBundle(Locale.getDefault()).getString("Boolean.true");
        return s == null ? this.getNull() : s.trim();
    }

    protected String getFalse() {
        String s = ConverterResource.getResourceBundle(Locale.getDefault()).getString("Boolean.false");
        return s == null ? this.getNull() : s.trim();
    }

    protected String getNull() {
        return "";
    }
}

