/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.exceptions;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import org.apache.log4j.Logger;

public class AWSExceptionFactory {
    static Logger logger = Logger.getLogger(AWSExceptionFactory.class);

    public static AmazonServiceException buildInternalServerException(String msg) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR, msg);
    }

    public static AmazonServiceException buildAWSException(AmazonServiceExceptionType type) {
        return AWSExceptionFactory.buildAWSException(type, null);
    }

    public static AmazonServiceException buildAWSException(AmazonServiceExceptionType type, String msg) {
        AmazonServiceException ret = null;
        String errorMessage = msg == null ? type.getMessage() : msg;
        ret = new AmazonServiceException(errorMessage);
        ret.setStatusCode(type.getResponseStatus());
        ret.setErrorCode(type.getErrorCode());
        return ret;
    }
}

