/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.HeightCalculator;
import com.itextpdf.tool.xml.css.WidthCalculator;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import com.itextpdf.tool.xml.html.pdfelement.HtmlCell;
import com.itextpdf.tool.xml.html.table.CellSpacingEvent;
import com.itextpdf.tool.xml.html.table.Table;
import com.itextpdf.tool.xml.html.table.TableStyleValues;
import java.util.Map;

public class HtmlCellCssApplier {
    private final CssUtils utils = CssUtils.getInstance();

    public HtmlCell apply(HtmlCell cell, Tag t, MarginMemory memory, PageSizeContainable psc) {
        Tag table;
        Tag row;
        for (row = t.getParent(); row != null && !row.getName().equals("tr"); row = row.getParent()) {
        }
        for (table = t.getParent(); table != null && !table.getName().equals("table"); table = table.getParent()) {
        }
        TableStyleValues values = Table.setBorderAttributeForCell(table);
        Map<String, String> css = t.getCSS();
        String emptyCells = css.get("empty-cells");
        if (null != emptyCells && "hide".equalsIgnoreCase(emptyCells) && cell.getCompositeElements() == null) {
            cell.setBorder(0);
        } else {
            String rowspan;
            String colspan;
            HeightCalculator heightCalc;
            Float height;
            cell.setVerticalAlignment(5);
            String vAlign = null;
            if (t.getAttributes().containsKey("valign")) {
                vAlign = t.getAttributes().get("valign");
            } else if (css.containsKey("valign")) {
                vAlign = css.get("valign");
            } else if (row != null) {
                if (row.getAttributes().containsKey("valign")) {
                    vAlign = row.getAttributes().get("valign");
                } else if (row.getCSS().containsKey("valign")) {
                    vAlign = row.getCSS().get("valign");
                }
            }
            if (vAlign != null) {
                if (vAlign.equalsIgnoreCase("top")) {
                    cell.setVerticalAlignment(4);
                } else if (vAlign.equalsIgnoreCase("bottom")) {
                    cell.setVerticalAlignment(6);
                }
            }
            String align = null;
            if (t.getAttributes().containsKey("align")) {
                align = t.getAttributes().get("align");
            } else if (css.containsKey("text-align")) {
                align = css.get("text-align");
            }
            if (align != null) {
                if (align.equalsIgnoreCase("center")) {
                    cell.setHorizontalAlignment(1);
                } else if (align.equalsIgnoreCase("right")) {
                    cell.setHorizontalAlignment(2);
                } else if (align.equalsIgnoreCase("justify")) {
                    cell.setHorizontalAlignment(3);
                }
            }
            if (t.getAttributes().get("width") != null || css.get("width") != null) {
                cell.setFixedWidth(new WidthCalculator().getWidth(t, memory.getRootTags(), psc.getPageSize().getWidth()));
            }
            if ((height = (heightCalc = new HeightCalculator()).getHeight(t, psc.getPageSize().getHeight())) == null && row != null) {
                height = heightCalc.getHeight(row, psc.getPageSize().getHeight());
            }
            if (height != null) {
                cell.setMinimumHeight(height.floatValue());
            }
            if (null != (colspan = t.getAttributes().get("colspan"))) {
                cell.setColspan(Integer.parseInt(colspan));
            }
            if (null != (rowspan = t.getAttributes().get("rowspan"))) {
                cell.setRowspan(Integer.parseInt(rowspan));
            }
            for (Map.Entry<String, String> entry : css.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                cell.setUseBorderPadding(true);
                if (key.equalsIgnoreCase("background-color")) {
                    values.setBackground(HtmlUtilities.decodeColor((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("vertical-align")) {
                    if (value.equalsIgnoreCase("top")) {
                        cell.setVerticalAlignment(4);
                        cell.setPaddingTop(cell.getPaddingTop() + 6.0f);
                        continue;
                    }
                    if (!value.equalsIgnoreCase("bottom")) continue;
                    cell.setVerticalAlignment(6);
                    cell.setPaddingBottom(cell.getPaddingBottom() + 6.0f);
                    continue;
                }
                if (key.contains("border")) {
                    if (key.contains("top")) {
                        this.setTopOfBorder(cell, key, value, values);
                        continue;
                    }
                    if (key.contains("bottom")) {
                        this.setBottomOfBorder(cell, key, value, values);
                        continue;
                    }
                    if (key.contains("left")) {
                        this.setLeftOfBorder(cell, key, value, values);
                        continue;
                    }
                    if (!key.contains("right")) continue;
                    this.setRightOfBorder(cell, key, value, values);
                    continue;
                }
                if (key.contains("cellpadding") || key.contains("padding")) {
                    if (key.contains("top")) {
                        cell.setPaddingTop(cell.getPaddingTop() + this.utils.parsePxInCmMmPcToPt(value));
                        continue;
                    }
                    if (key.contains("bottom")) {
                        cell.setPaddingBottom(cell.getPaddingBottom() + this.utils.parsePxInCmMmPcToPt(value));
                        continue;
                    }
                    if (key.contains("left")) {
                        cell.setPaddingLeft(cell.getPaddingLeft() + this.utils.parsePxInCmMmPcToPt(value));
                        continue;
                    }
                    if (!key.contains("right")) continue;
                    cell.setPaddingRight(cell.getPaddingRight() + this.utils.parsePxInCmMmPcToPt(value));
                    continue;
                }
                if (!key.contains("text-align")) continue;
                if (value.equalsIgnoreCase("left")) {
                    cell.setHorizontalAlignment(0);
                    continue;
                }
                if (value.equalsIgnoreCase("center")) {
                    cell.setHorizontalAlignment(1);
                    continue;
                }
                if (!value.equalsIgnoreCase("right")) continue;
                cell.setHorizontalAlignment(2);
            }
            cell.setPaddingLeft(cell.getPaddingLeft() + values.getHorBorderSpacing() + values.getBorderWidthLeft());
            cell.setPaddingRight(cell.getPaddingRight() + values.getBorderWidthRight());
            cell.setPaddingTop(cell.getPaddingTop() + values.getVerBorderSpacing() + values.getBorderWidthTop());
            cell.setPaddingBottom(cell.getPaddingBottom() + values.getBorderWidthBottom());
        }
        cell.setBorder(0);
        cell.setCellEvent(new CellSpacingEvent(values));
        cell.setCellValues(values);
        return cell;
    }

    private void setTopOfBorder(HtmlCell cell, String key, String value, TableStyleValues values) {
        if (key.contains("width")) {
            values.setBorderWidthTop(this.utils.parsePxInCmMmPcToPt(value));
        }
        if (key.contains("color")) {
            values.setBorderColorTop(HtmlUtilities.decodeColor((String)value));
        } else if (values.getBorderColorTop() == null) {
            values.setBorderColorTop(BaseColor.BLACK);
        }
        if (key.contains("style") && values.getBorderWidthTop() == 0.0f) {
            values.setBorderWidthTop(2.25f);
        }
    }

    private void setBottomOfBorder(HtmlCell cell, String key, String value, TableStyleValues values) {
        if (key.contains("width")) {
            values.setBorderWidthBottom(this.utils.parsePxInCmMmPcToPt(value));
        }
        if (key.contains("color")) {
            values.setBorderColorBottom(HtmlUtilities.decodeColor((String)value));
        } else if (values.getBorderColorBottom() == null) {
            values.setBorderColorBottom(BaseColor.BLACK);
        }
        if (key.contains("style") && values.getBorderWidthBottom() == 0.0f) {
            values.setBorderWidthBottom(2.25f);
        }
    }

    private void setLeftOfBorder(HtmlCell cell, String key, String value, TableStyleValues values) {
        if (key.contains("width")) {
            values.setBorderWidthLeft(this.utils.parsePxInCmMmPcToPt(value));
        }
        if (key.contains("color")) {
            values.setBorderColorLeft(HtmlUtilities.decodeColor((String)value));
        } else if (values.getBorderColorLeft() == null) {
            values.setBorderColorLeft(BaseColor.BLACK);
        }
        if (key.contains("style") && values.getBorderWidthLeft() == 0.0f) {
            values.setBorderWidthLeft(2.25f);
        }
    }

    private void setRightOfBorder(HtmlCell cell, String key, String value, TableStyleValues values) {
        if (key.contains("width")) {
            values.setBorderWidthRight(this.utils.parsePxInCmMmPcToPt(value));
        }
        if (key.contains("color")) {
            values.setBorderColorRight(HtmlUtilities.decodeColor((String)value));
        } else if (values.getBorderColorRight() == null) {
            values.setBorderColorRight(BaseColor.BLACK);
        }
        if (key.contains("style") && values.getBorderWidthRight() == 0.0f) {
            values.setBorderWidthRight(2.25f);
        }
    }
}

