/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.property;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphOrphansControl {
    private int minOrphans;

    public ParagraphOrphansControl(int minOrphans) {
        this.minOrphans = minOrphans;
    }

    public ParagraphOrphansControl setMinAllowedOrphans(int minOrphans) {
        this.minOrphans = minOrphans;
        return this;
    }

    public int getMinOrphans() {
        return this.minOrphans;
    }

    public void handleViolatedOrphans(ParagraphRenderer renderer, String message) {
        Logger logger = LoggerFactory.getLogger(ParagraphOrphansControl.class);
        if (renderer.getOccupiedArea() != null && renderer.getLines() != null) {
            int pageNumber = renderer.getOccupiedArea().getPageNumber();
            String warnText = MessageFormatUtil.format((String)"Orphans constraint violated for paragraph split at page {0}. Min number of orphans: {1}; actual: {2}. \nComment: {3}", (Object[])new Object[]{pageNumber, this.minOrphans, renderer.getLines().size(), message});
            logger.warn(warnText);
        } else {
            logger.warn("Premature call of handleViolation method.");
        }
    }
}

