/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class NotNullVerifyingInstrumenter
extends ClassAdapter {
    private boolean myIsModification = false;
    private boolean myIsNotStaticInner = false;
    private String myClassName;
    private String mySuperName;
    private static final String ENUM_CLASS_NAME = "java/lang/Enum";
    private static final String CONSTRUCTOR_NAME = "<init>";

    public NotNullVerifyingInstrumenter(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public boolean isModification() {
        return this.myIsModification;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myClassName = name;
        this.mySuperName = superName;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if (this.myClassName.equals(name)) {
            this.myIsNotStaticInner = (access & 8) == 0;
        }
    }

    public MethodVisitor visitMethod(final int access, final String name, String desc, String signature, String[] exceptions) {
        final Type[] args = Type.getArgumentTypes((String)desc);
        final Type returnType = Type.getReturnType((String)desc);
        final int startParameter = this.getStartParameterIndex(name);
        MethodVisitor v = this.cv.visitMethod(access, name, desc, signature, exceptions);
        return new MethodAdapter(v){
            private final ArrayList myNotNullParams = new ArrayList();
            private boolean myIsNotNull = false;
            public Label myThrowLabel;
            private Label myStartGeneratedCodeLabel;

            public AnnotationVisitor visitParameterAnnotation(int parameter, String anno, boolean visible) {
                AnnotationVisitor av = this.mv.visitParameterAnnotation(parameter, anno, visible);
                if (NotNullVerifyingInstrumenter.isReferenceType(args[parameter]) && anno.equals("Lorg/jetbrains/annotations/NotNull;")) {
                    this.myNotNullParams.add(new Integer(parameter));
                }
                return av;
            }

            public AnnotationVisitor visitAnnotation(String anno, boolean isRuntime) {
                AnnotationVisitor av = this.mv.visitAnnotation(anno, isRuntime);
                if (NotNullVerifyingInstrumenter.isReferenceType(returnType) && anno.equals("Lorg/jetbrains/annotations/NotNull;")) {
                    this.myIsNotNull = true;
                }
                return av;
            }

            public void visitCode() {
                if (this.myIsNotNull || this.myNotNullParams.size() > 0) {
                    this.myStartGeneratedCodeLabel = new Label();
                    this.mv.visitLabel(this.myStartGeneratedCodeLabel);
                }
                int p = 0;
                while (p < this.myNotNullParams.size()) {
                    int var = (access & 8) == 0 ? 1 : 0;
                    int param = (Integer)this.myNotNullParams.get(p);
                    int i = 0;
                    while (i < param + startParameter) {
                        var += args[i].getSize();
                        ++i;
                    }
                    this.mv.visitVarInsn(25, var);
                    Label end = new Label();
                    this.mv.visitJumpInsn(199, end);
                    this.generateThrow("java/lang/IllegalArgumentException", "Argument " + param + " for @NotNull parameter of " + NotNullVerifyingInstrumenter.this.myClassName + "." + name + " must not be null", end);
                    ++p;
                }
                if (this.myIsNotNull) {
                    Label codeStart = new Label();
                    this.mv.visitJumpInsn(167, codeStart);
                    this.myThrowLabel = new Label();
                    this.mv.visitLabel(this.myThrowLabel);
                    this.generateThrow("java/lang/IllegalStateException", "@NotNull method " + NotNullVerifyingInstrumenter.this.myClassName + "." + name + " must not return null", codeStart);
                }
            }

            public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int index) {
                boolean isStatic;
                boolean bl = isStatic = (access & 8) != 0;
                boolean isParameter = isStatic ? index < args.length : index <= args.length;
                this.mv.visitLocalVariable(name2, desc, signature, isParameter && this.myStartGeneratedCodeLabel != null ? this.myStartGeneratedCodeLabel : start, end, index);
            }

            public void visitInsn(int opcode) {
                if (opcode == 176 && this.myIsNotNull) {
                    this.mv.visitInsn(89);
                    this.mv.visitJumpInsn(198, this.myThrowLabel);
                }
                this.mv.visitInsn(opcode);
            }

            private void generateThrow(String exceptionClass, String descr, Label end) {
                String exceptionParamClass = "(Ljava/lang/String;)V";
                this.mv.visitTypeInsn(187, exceptionClass);
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)descr);
                this.mv.visitMethodInsn(183, exceptionClass, NotNullVerifyingInstrumenter.CONSTRUCTOR_NAME, exceptionParamClass);
                this.mv.visitInsn(191);
                this.mv.visitLabel(end);
                NotNullVerifyingInstrumenter.this.myIsModification = true;
            }
        };
    }

    private int getStartParameterIndex(String name) {
        int result = 0;
        if (CONSTRUCTOR_NAME.equals(name)) {
            if (this.mySuperName.equals(ENUM_CLASS_NAME)) {
                result += 2;
            }
            if (this.myIsNotStaticInner) {
                ++result;
            }
        }
        return result;
    }

    private static boolean isReferenceType(Type type) {
        return type.getSort() == 10 || type.getSort() == 9;
    }
}

