/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpManager {
    protected static final Logger log = LoggerFactory.getLogger(SmtpManager.class);
    Incoming _incomingQueue;
    UserManager userManager;
    private ImapHostManager imapHostManager;
    List<CountDownLatch> notifyList;

    public SmtpManager(ImapHostManager imapHostManager, UserManager userManager) {
        this.imapHostManager = imapHostManager;
        this.userManager = userManager;
        this._incomingQueue = new Incoming();
        this.notifyList = Collections.synchronizedList(new ArrayList());
    }

    public String checkSender(SmtpState state, MailAddress sender) {
        return null;
    }

    public String checkRecipient(SmtpState state, MailAddress rcpt) {
        return null;
    }

    public String checkData(SmtpState state) {
        return null;
    }

    public synchronized void send(SmtpState state) {
        this._incomingQueue.enqueue(state.getMessage());
        for (CountDownLatch o : this.notifyList) {
            o.countDown();
        }
    }

    public synchronized CountDownLatch createAndAddNewWaitObject(int emailCount) {
        int existingCount = this.imapHostManager.getAllMessages().size();
        if (existingCount >= emailCount) {
            return new CountDownLatch(0);
        }
        CountDownLatch latch = new CountDownLatch(emailCount - existingCount);
        this.notifyList.add(latch);
        return latch;
    }

    private class Incoming {
        private Incoming() {
        }

        public void enqueue(MovingMessage msg) {
            for (MailAddress address : msg.getToAddresses()) {
                this.handle(msg, address);
            }
        }

        private void handle(MovingMessage msg, MailAddress mailAddress) {
            try {
                GreenMailUser user = SmtpManager.this.userManager.getUserByEmail(mailAddress.getEmail());
                if (null == user) {
                    String login = mailAddress.getEmail();
                    String email = mailAddress.getEmail();
                    String password = mailAddress.getEmail();
                    user = SmtpManager.this.userManager.createUser(email, login, password);
                    log.info("Created user login {} for address {} with password {} because it didn't exist before.", new Object[]{login, email, password});
                }
                user.deliver(msg);
            }
            catch (Exception e) {
                log.error("Can not deliver message {} to {}", new Object[]{msg, mailAddress, e});
                throw new RuntimeException(e);
            }
            msg.releaseContent();
        }
    }
}

