/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.util.DummySSLServerSocketFactory;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.Service;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Vector;

public abstract class AbstractServer
extends Service {
    protected final InetAddress bindTo;
    protected ServerSocket serverSocket = null;
    protected Vector handlers = null;
    protected Managers managers;
    protected ServerSetup setup;

    protected AbstractServer(ServerSetup setup, Managers managers) {
        try {
            this.setup = setup;
            this.bindTo = setup.getBindAddress() == null ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName(setup.getBindAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.managers = managers;
        this.handlers = new Vector();
    }

    protected synchronized ServerSocket openServerSocket() throws IOException {
        ServerSocket ret = null;
        BindException retEx = null;
        for (int i = 0; i < 25 && null == ret; ++i) {
            try {
                if (this.setup.isSecure()) {
                    ret = DummySSLServerSocketFactory.getDefault().createServerSocket(this.setup.getPort(), 0, this.bindTo);
                    continue;
                }
                ret = new ServerSocket(this.setup.getPort(), 0, this.bindTo);
                continue;
            }
            catch (BindException e) {
                try {
                    retEx = e;
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
        }
        if (null == ret && null != retEx) {
            throw retEx;
        }
        return ret;
    }

    public String getBindTo() {
        return this.bindTo.getHostAddress();
    }

    public int getPort() {
        return this.setup.getPort();
    }

    public String getProtocol() {
        return this.setup.getProtocol();
    }

    public ServerSetup getServerSetup() {
        return this.setup;
    }

    public String toString() {
        return null != this.setup ? this.setup.getProtocol() + ':' + this.setup.getPort() : super.toString();
    }
}

