<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012, 2013 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<%@taglib uri="http://shiro.apache.org/tags" prefix="shiro" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Gestion étiquettes</title>
    </head>
    <body>
        <h1>Gestion étiquettes</h1>

		<fieldset>
			<legend>Filtre</legend>

			<form action="<s:url action='label-history' namespace='/user' />">
              <s:actionerror />
              De&thinsp;:&thinsp;<input type="text" name="beginDate" size="10" class="sgqdatefield"
              <s:if test="beginDate != null">
                  value="<s:text name="sgq.web.common.dateformat">
                    <s:param value="beginDate"/>
                  </s:text>"
              </s:if> />
	            à&thinsp;:&thinsp;<input type="text" name="endDate" size="10" class="sgqdatefield"
              <s:if test="endDate != null">
                  value="<s:text name="sgq.web.common.dateformat">
                    <s:param value="endDate"/>
                  </s:text>"
              </s:if> />
              <input type="submit" value="Rechercher" /></p>
	        </form>
		</fieldset>

        <h3>Historique des corrections d'étiquettes (<s:property value="pager.records" /> r&eacute;sultats) :</h3>

        <table class="listing">
            <tr>
              <th>Source</th>
              <th>Date</th>
              <th>Données</th>
              <th>État</th>
              <th>Commentaire</th>
            </tr>
            <s:iterator value="labelErrors" var="labelError">
            	<tr>
                    <td>
                      <s:if test="#labelError.source==@com.herbocailleau.sgq.entities.Zone@ZE">
                        FIF_HIST.txt
                      </s:if>
                      <s:if test="#labelError.source==@com.herbocailleau.sgq.entities.Zone@ZP">
                        FIC_HIST.txt
                      </s:if>
                    </td>
                    <td><s:text name="sgq.web.common.dateformat">
                      <s:param value="#labelError.labelDate"/>
                    </s:text></td>
                    <td title="<s:property value="#labelError.message"/>"><s:property value="#labelError.line"/></td>
                    <td>
                      <s:if test="#labelError.modified">Corrigé</s:if>
                      <s:if test="#labelError.deleted">Supprimé</s:if>
                    </td>
                    <td><s:property value="#labelError.comment"/></td>
	            </tr>
            </s:iterator>
        </table>

        <jsp:include page="../pager.jsp" />

        <a href="<s:url action="label-history-export" includeParams="get" />">Export CSV</a>
    </body>
</html>
