<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Référentiel produits</title>
    </head>
    <body>
    	<h1>Référentiel produits</h1>
    	
    	<h2>Produits</h2>
    	
        <s:property value="pager.records" /> produits trouvés:

    	<table class="listing" style="min-width:1400px">
    	   <tr>
    	       <th>Code</th>
    	       <th>Nom</th>
               <th>Categorie</th>
    	       <th>Nom latin</th>
    	       <th>Famille</th>
    	       <th>Statuts</th>
    	       <th>Analyses</th>
               <th>Contr&ocirc;le</th>
               <th title="Commentaire">Co.</th>
    	   </tr>
    	   <s:iterator value="products" var="product">
    	   	 <tr>
    	       <td>
                 <a href="<s:url action='product!input' namespace='/admin'>
                     <s:param name="productId"><s:property value="topiaId" /></s:param>
                   </s:url>">
                   <s:property value="code" />
                 </a>
               </td>
    	       <td>
                 <a href="<s:url action='product!input' namespace='/admin'>
                   <s:param name="productId"><s:property value="topiaId" /></s:param>
                   </s:url>">
                   <s:property value="name" />
                 </a>
               </td>
               <td><s:property value="category" /></td>
    	       <td><s:property value="latinName" /></td>
    	       <td><s:property value="family" /></td>
    	       <td>
                 <ul>
                    <s:iterator value="productStatus">
                      <li><s:property value="name" /></li>
                    </s:iterator>
                 </ul></td>
    	       <td>
                 <ul>
                    <s:iterator value="analyzeType">
                      <li><s:property value="name" /></li>
                    </s:iterator>
                 </ul>
               </td>
               <td>
                 <s:if test="#product.botanicControl">
                    Botanique
                 </s:if>
                 <s:elseif test="#product.identificationControl">
                    Identification
                 </s:elseif>
               </td>
               <td>
                 <s:if test="#product.comment.length() != 0">
                   <img src="<s:url value='/img/note_edit.png' />" alt="Commentaire"
                        title="<s:property value="comment" />" />
                 </s:if>
               </td>
    	     </tr>
    	   </s:iterator>
    	</table>

        <div class="pagination">
           <s:iterator var="index" begin="0" end="pager.pagesNumber - 1">
                <s:if test="%{#index == pager.pageIndex}">
                    <span class="current"><s:property value="#index + 1" /></span>
                </s:if>
                <s:else>
                    <a href="<s:url includeParams="get">
                        <s:param name="page">
                            <s:property />
                        </s:param>
                    </s:url>">
                        <s:property value="#index + 1" />
                    </a>
                </s:else>
           </s:iterator>
        </div>

        <s:if test="pager.records == 0">
            <h2>Import produit</h2>
            <form action="<s:url action='products-import' namespace='/admin' />" method="post" enctype="multipart/form-data">
               <input type="file" name="file" />
               <input type="submit" value="Importer" />
            </form>
        </s:if>
    	<s:else>
           <a href="<s:url action='product!input' namespace='/admin' />">
             Nouveau produit
           </a>
        </s:else>
    </body>
</html>
