/*
 * #%L
 * SGQ :: Web
 * $Id: SetupAction.java 103 2012-09-27 09:00:43Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/SetupAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de configuration.
 * 
 * @author echatellier
 */
public class SetupAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected long batchCount;

    protected File file;

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String execute() throws Exception {
        BatchService batchService = newService(BatchService.class);
        if (file != null) {
            batchService.recoverBatchFile(file);
        }
        batchCount = batchService.getBatchCount();
        return SUCCESS;
    }

    public long getBatchCount() {
        return batchCount;
    }
}
