/*
 * #%L
 * SGQ :: Web
 * $Id: PlacesAction.java 110 2012-10-01 16:26:40Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/PlacesAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.herbocailleau.sgq.business.model.PresentationModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class PlacesAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(PlacesAction.class);

    protected ReferentialService referentialService;

    protected List<Place> places;

    protected Place place;

    protected String placeId;

    protected Map<Place, List<PresentationModel>> batchPresentations;

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    @Override
    public String execute() throws Exception {
        referentialService = newService(ReferentialService.class);
        places = referentialService.getPlaces();
        if (placeId != null) {
            place = referentialService.getPlaceById(placeId);
        }
        BatchService batchService = newService(BatchService.class);
        batchPresentations = batchService.findAllBatchPerPlaces(place);
        return SUCCESS;
    }

    public List<Place> getPlaces() {
        return places;
    }

    public Place getPlace() {
        return place;
    }

    public Map<Place, List<PresentationModel>> getBatchPresentations() {
        return batchPresentations;
    }
}
