/*
 * #%L
 * SGQ :: Web
 * $Id: InventoryAction.java 109 2012-10-01 15:37:55Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/InventoryAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class InventoryAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(InventoryAction.class);

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    @Action(value="inventory-export", results= {@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String export() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        BatchService batchService = newService(BatchService.class);
        InputStream result = null;
        try {
            result = batchService.exportInventory();
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't get csv stream", ex);
            }
        }
        return result;
    }

    public String getFilename() {
        return "inventaire.csv";
    }
}
