/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesDashboardAction.java 77 2012-09-19 16:32:29Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesDashboardAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.AnalyzeFilter;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Action d'affichage des analyses en attente de preparation et celle
 * à recevoir.
 * Gere egalement la validation du formulaire (envoi des preparations).
 * 
 * @author echatellier
 */
public class AnalyzesDashboardAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected ReferentialService referentialService;

    protected BatchService batchService;

    protected List<Analyze> analysisToSend;

    protected List<Analyze> analysisToReceive;

    protected String analyzeTypeId;

    protected String supplier;

    protected String sentDateBegin;

    protected String sentDateEnd;

    protected int batchNumberBegin;

    protected int batchNumberEnd;

    protected AnalyzeType analyzeType;

    protected List<AnalyzeType> analyzeTypes;

    protected List<Supplier> suppliers;

    /** Validation du formulaire : liste des analyses selectionées. */
    protected List<String> analyzeIds;

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getSentDateBegin() {
        return sentDateBegin;
    }

    public void setSentDateBegin(String sentDateBegin) {
        this.sentDateBegin = sentDateBegin;
    }

    public String getSentDateEnd() {
        return sentDateEnd;
    }

    public void setSentDateEnd(String sentDateEnd) {
        this.sentDateEnd = sentDateEnd;
    }

    public int getBatchNumberBegin() {
        return batchNumberBegin;
    }

    public void setBatchNumberBegin(int batchNumberBegin) {
        this.batchNumberBegin = batchNumberBegin;
    }

    public int getBatchNumberEnd() {
        return batchNumberEnd;
    }

    public void setBatchNumberEnd(int batchNumberEnd) {
        this.batchNumberEnd = batchNumberEnd;
    }

    @Override
    public void prepare() throws Exception {
        referentialService = newService(ReferentialService.class);
        batchService = newService(BatchService.class);
    }

    protected void loadData() {
        // le reste sert seulement s'il y a une erreur lors de la validation
        // et que l'on revient au mode input
        analyzeTypes = referentialService.findAllAnalyzeTypes();
        suppliers = referentialService.getAllSupplierOnlyLabs();

        if (StringUtils.isNotEmpty(analyzeTypeId)) {
            analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
        }

        AnalyzeFilter filter = new AnalyzeFilter();
        filter.setAnalyzeType(analyzeType);
        filter.setBatchNumberBegin(batchNumberBegin);
        filter.setBatchNumberEnd(batchNumberEnd);
        if (StringUtils.isNotBlank(sentDateBegin)) {
            try {
                filter.setSentDateBegin(SgqUtils.parseSgqDate(sentDateBegin));
            } catch (ParseException ex) {
                addActionError("Date invalide (dd/mm/yyyy) : " + sentDateBegin);
            }
        }
        if (StringUtils.isNotBlank(sentDateEnd)) {
            try {
                filter.setSentDateEnd(SgqUtils.parseSgqDate(sentDateEnd));
            } catch (ParseException ex) {
                addActionError("Date invalide (dd/mm/yyyy) : " + sentDateEnd);
            }
        }
        filter.setSupplier(supplier);

        BatchService batchService = newService(BatchService.class);
        analysisToSend = batchService.getAnalysisToSend(filter);
        analysisToReceive = batchService.getAnalysisToReceive(filter);
    }

    @Override
    public String input() throws Exception {
        loadData();
        return super.input();
    }

    public AnalyzeType getAnalyzeType() {
        return analyzeType;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    public List<Supplier> getSuppliers() {
        return suppliers;
    }

    public List<Analyze> getAnalysisToSend() {
        return analysisToSend;
    }

    public List<Analyze> getAnalysisToReceive() {
        return analysisToReceive;
    }

    public Date getNow() {
        return new Date();
    }

    public void setAnalyzeIds(List<String> analyzeIds) {
        this.analyzeIds = analyzeIds;
    }

    @Override
    public void validate() {
        if (analyzeIds != null) {
            for (String analyzeId : analyzeIds) {
                Analyze analyze = batchService.getAnalyzeById(analyzeId);

                String supplierId = getParameter("supplier." + analyze.getTopiaId());
                Supplier supplier = referentialService.getSupplierById(supplierId);
                
                if (supplier == null) {
                    addActionError("Prestataire manquant pour l'analyze " + analyze.getAnalyzeType().getName()
                            + " du lot " + analyze.getBatch().getNumber());
                }
                
                String date = getParameter("sentDate." + analyze.getTopiaId());
                try {
                    SgqUtils.parseSgqDate(date);
                } catch (ParseException ex) {
                    addActionError("Date invalide l'analyze " + analyze.getAnalyzeType().getName()
                            + " du lot " + analyze.getBatch().getNumber());
                }
            }
        } else {
            addActionError("Aucune analyze selectionnée");
        }
        
        if (hasErrors()) {
            loadData();
        }
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "analyzes-dashboard!input"})})
    public String execute() throws Exception {
        if (analyzeIds != null) {
            for (String analyzeId : analyzeIds) {
                Analyze analyze = batchService.getAnalyzeById(analyzeId);

                String supplierId = getParameter("supplier." + analyze.getTopiaId());
                Supplier supplier = referentialService.getSupplierById(supplierId);

                String date = getParameter("sentDate." + analyze.getTopiaId());
                Date sentDate = SgqUtils.parseSgqDate(date); // can't fail here
                batchService.sendAnalyzeToSupplier(analyze, sentDate, supplier);
            }
        }

        return super.execute();
    }
}
