<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Gestion des analyzes</title>
    </head>
    <body>
        <h1>Gestion des analyses</h1>

		<fieldset>
			<legend>Filtre</legend>
			<s:form method="get">
                <s:select
                    name="analyzeTypeId"
                    emptyOption="true"
                    key="Filtrer par type d'analyse"
                    list="analyzeTypes"
                    listKey="topiaId"
                    listValue="name"
                    value="analyzeType.topiaId"
                    onchange="this.form.submit()"/>
                
	        </s:form>
		</fieldset>

        <h3>Échantillion à préparer:</h3>
        
        <s:form action="analyzes-send">
	        <table class="listing">
	            <tr>
	                <th>Lot</th>
	                <th>Plante</th>
	                <th>DPMES</th>
	                <th>Type d'analyse</th>
	                <th>Date limite d'envoi</th>
	                <th>Fournisseur</th>
	                <th>Fait</th>
	            </tr>
                <s:iterator value="analysisToSend">
                    <tr>
                        <td><a href="<s:url action='batch' namespace='/user'>
                            <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                        </s:url>"><s:property value="batch.number" /></a></td>
                        <td><a href="<s:url action='batch' namespace='/user'>
                            <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                        </s:url>"><s:property value="batch.product.name" /></a></td>
                        <td><s:property value="batch.dpmes" /></td>
                        <td><s:property value="analyzeType.name" /></td>
                        <td></td>
                        <td>
                            <select name="supplier.<s:property value="topiaId" />">
                            <option></option>
                            <s:set var="test" value='%{false}'/>
                            <optgroup label="Laboratoires">
                            <s:iterator value="suppliers">
                                <s:if test='!#test'>
                                    <s:if test="!laboratory">
                                        </optgroup>
                                        <optgroup label="Fournisseurs">
                                        <s:set var="test" value='%{true}'/>
                                    </s:if>
                                    
                                </s:if>
                                <option value="<s:property value="topiaId" />"><s:property value="name" /></option>
                            </s:iterator>
                            </optgroup>
                            </select>
                        </td>
                        <td><input type="checkbox" name="analyzeIds" value="<s:property value="topiaId" />" /></td>
                    </tr>
                </s:iterator>
	        </table>
	        <input type="submit" value="Valider l'envoi" />
        </s:form>

        <h3>Analyses en attente:</h3>

        <table class="listing">
            <tr>
                <th>Lot</th>
                <th>Plante</th>
                <th>DPMES</th>
                <th>Type d'analyse</th>
                <th>Envoyé le</th>
                <th>Fournisseur</th>
                <th>Analyse reçue</th>
            </tr>
            <s:iterator value="analysisToReceive">
                <tr>
                    <td><a href="<s:url action='batch' namespace='/user'>
                        <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                    </s:url>"><s:property value="batch.number" /></a></td>
                    <td><a href="<s:url action='batch' namespace='/user'>
                        <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                    </s:url>"><s:property value="batch.product.name" /></a></td>
                    <td><s:property value="batch.dpmes" /></td>
                    <td><s:property value="analyzeType.name" /></td>
                    <td><s:text name="sgq.web.common.dateformat">
                        <s:param value="sentDate"/>
                      </s:text></td>
                    <td>
                        <%-- <select name="supplier.<s:property value="topiaId" />">
                        <option></option>
                        <s:set var="test" value='%{false}'/>
                        <optgroup label="Laboratoires">
                        <s:iterator value="suppliers">
                            <s:if test='!#test'>
                                <s:if test="!laboratory">
                                    </optgroup>
                                    <optgroup label="Fournisseurs">
                                    <s:set var="test" value='%{true}'/>
                                </s:if>
                                
                            </s:if>
                            <option value="<s:property value="topiaId" />"><s:property value="name" /></option>
                        </s:iterator>
                        </optgroup>
                        </select>--%>
                        <s:property value="supplier.name" />
                    </td>
                    <td>
                        <a href="<s:url action='analyzes-receipt' namespace='/user'>
                            <s:param name="analyzeId"><s:property value="topiaId" /></s:param>
                        </s:url>">
                            Valider la réception
                        </a>
                    </td>
                </tr>
            </s:iterator>
        </table>
    </body>
</html>
