/*
 * #%L
 * SGQ :: Web
 * $Id: BatchPresentationEditAction.java 53 2012-09-11 16:11:13Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchPresentationEditAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'affichage du détail d'une presentation.
 * 
 * @author echatellier
 */
public class BatchPresentationEditAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String presentationId;

    protected Presentation presentation;

    public void setPresentationId(String presentationId) {
        this.presentationId = presentationId;
    }

    @Override
    public String execute() throws Exception {
        BatchService batchService = newService(BatchService.class);
        presentation = batchService.getPresentationById(presentationId);
        return SUCCESS;
    }

    public Presentation getPresentation() {
        return presentation;
    }
}
