/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de detail d'un lot.
 * Comprenant detail du lot, analyses et presentation.
 * 
 * @author echatellier
 */
public class BatchAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String batchId;

    protected Batch batch;

    protected List<Presentation> presentations;

    protected List<Analyze> analyzes;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Override
    public String execute() throws Exception {

        BatchService batchService = newService(BatchService.class);
        batch = batchService.getBatchById(batchId);

        presentations = batchService.findAllPresentationsByBatch(batch);
        analyzes = batchService.findAllAnalyzesByBatch(batch);
        return SUCCESS;
    }

    public Batch getBatch() {
        return batch;
    }

    public List<Presentation> getPresentations() {
        return presentations;
    }

    public List<Analyze> getAnalyzes() {
        return analyzes;
    }

}
