/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de preparation des analyses pour plusieurs lots.
 * 
 * @author echatellier
 */
public class AnalyzesAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected int startNumber;

    protected int endNumber;

    protected List<Batch> batches;

    protected List<AnalyzeType> analyzeTypes;

    public void setStartNumber(int startNumber) {
        this.startNumber = startNumber;
    }

    public int getStartNumber() {
        return startNumber;
    }

    public void setEndNumber(int endNumber) {
        this.endNumber = endNumber;
    }

    public int getEndNumber() {
        return endNumber;
    }

    @Override
    public String execute() throws Exception {

        if (startNumber != 0 && endNumber != 0) {
            BatchService batchService = newService(BatchService.class);
            batches = batchService.findAllBetweenNumbers(startNumber, endNumber);
            
            ReferentialService referentialService = newService(ReferentialService.class);
            analyzeTypes = referentialService.findAllAnalyzeTypes();
        }

        return SUCCESS;
    }

    public List<Batch> getBatches() {
        return batches;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }
}
