/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzeTypeUpdateAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/AnalyzeTypeUpdateAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class AnalyzeTypeUpdateAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6915148559808770928L;

    protected String analyzeTypeId;

    protected List<AnalyzeCategory> analyzeCategories;

    protected AnalyzeType analyzeType;

    @Override
    public String execute() throws Exception {
        
        ReferentialService referentialService = newService(ReferentialService.class);
        analyzeCategories = referentialService.findAllAnalyzeCategories();
        if (analyzeTypeId != null) {
            analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
        } else {
            analyzeType = new AnalyzeTypeImpl();
            analyzeType.setDurationDays(30); // default value
        }

        return SUCCESS;
    }

    public List<AnalyzeCategory> getAnalyzeCategories() {
        return analyzeCategories;
    }

    public AnalyzeType getAnalyzeType() {
        return analyzeType;
    }

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }
}
