/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchAnalyzeDAO;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SupplierDAOAbstract<E extends Supplier>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return Supplier.class;
    }

    public SGQDAOHelper.SGQEntityEnum getTopiaEntityEnum() {
        return SGQDAOHelper.SGQEntityEnum.Supplier;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getDAO(Batch.class).findAllByProperties("supplier", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getSupplier())) continue;
            item.setSupplier(null);
        }
        list = this.getContext().getDAO(BatchAnalyze.class).findAllByProperties("supplier", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getSupplier())) continue;
            item.setSupplier(null);
        }
        super.delete(entity);
    }

    public E findByNaturalId(String code) throws TopiaException {
        return (E)((Supplier)this.findByProperties("code", code, new Object[0]));
    }

    public boolean existByNaturalId(String code) throws TopiaException {
        return this.existByProperties("code", code, new Object[0]);
    }

    @Deprecated
    public E create(String code) throws TopiaException {
        return (E)((Supplier)this.create(new Object[]{"code", code}));
    }

    public E createByNaturalId(String code) throws TopiaException {
        return (E)((Supplier)this.create(new Object[]{"code", code}));
    }

    public E createByNotNull(String code) throws TopiaException {
        return (E)((Supplier)this.create(new Object[]{"code", code}));
    }

    public E findByCode(String v) throws TopiaException {
        Supplier result = (Supplier)this.findByProperty("code", v);
        return (E)result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List result = this.findAllByProperty("code", v);
        return result;
    }

    public E findByName(String v) throws TopiaException {
        Supplier result = (Supplier)this.findByProperty("name", v);
        return (E)result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List result = this.findAllByProperty("name", v);
        return result;
    }

    public E findByLaboratory(boolean v) throws TopiaException {
        Supplier result = (Supplier)this.findByProperty("laboratory", v);
        return (E)result;
    }

    public List<E> findAllByLaboratory(boolean v) throws TopiaException {
        List result = this.findAllByProperty("laboratory", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List tmp;
        TopiaDAOImpl dao;
        ArrayList result = new ArrayList();
        if (type == BatchAnalyze.class) {
            dao = (BatchAnalyzeDAO)this.getContext().getDAO(BatchAnalyze.class);
            tmp = dao.findAllBySupplier((Supplier)entity);
            result.addAll(tmp);
        }
        if (type == Batch.class) {
            dao = (BatchDAO)this.getContext().getDAO(Batch.class);
            tmp = dao.findAllBySupplier((Supplier)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        List<Object> list = this.findUsages(BatchAnalyze.class, entity);
        if (!list.isEmpty()) {
            result.put(BatchAnalyze.class, list);
        }
        if (!(list = this.findUsages(Batch.class, entity)).isEmpty()) {
            result.put(Batch.class, list);
        }
        return result;
    }
}

