/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services.csv;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchAnalyzeImpl;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SynthesisMention;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

public class AnalyzeImportModel
extends AbstractImportModel<BatchAnalyze> {
    public AnalyzeImportModel(final BatchDAO batchDAO, final Map<String, AnalyzeType> analyzeTypes, final Map<String, Supplier> suppliers) {
        super(';');
        this.newMandatoryColumn("N\u00b0Lot", "batch", (ValueParser)new ValueParser<Batch>(){

            public Batch parse(String value) throws ParseException {
                int number = Integer.parseInt(value);
                Batch result = null;
                try {
                    result = (Batch)batchDAO.findByNumber(number);
                }
                catch (TopiaException e) {
                    throw new SgqBusinessException("Can't get batch", e);
                }
                return result;
            }
        });
        this.newIgnoredColumn("Cat\u00e9gorie");
        this.newMandatoryColumn("Type", "analyzeType", (ValueParser)new ValueParser<AnalyzeType>(){

            public AnalyzeType parse(String value) throws ParseException {
                AnalyzeType type = (AnalyzeType)analyzeTypes.get(value);
                if (type == null) {
                    throw new SgqBusinessException(I18n._((String)"Le type d'analyze est obligatoire %s", (Object[])new Object[]{value}));
                }
                return type;
            }
        });
        this.newMandatoryColumn("Qualification", "synthesisMention", (ValueParser)new ValueParser<SynthesisMention>(){

            public SynthesisMention parse(String value) throws ParseException {
                SynthesisMention result;
                if ("Conforme".equals(value)) {
                    result = SynthesisMention.CONFORM;
                } else if ("Acceptable".equals(value)) {
                    result = SynthesisMention.ACCEPTABLE;
                } else if ("Non acceptable".equals(value)) {
                    result = SynthesisMention.NOT_ACCEPTABLE;
                } else {
                    throw new SgqBusinessException(I18n._((String)"Qualification de l'analyze inconnue", (Object[])new Object[]{value}));
                }
                return result;
            }
        });
        this.newMandatoryColumn("Commentaire", "synthesis");
        this.newMandatoryColumn("Prestataire", "supplier", (ValueParser)new ValueParser<Supplier>(){

            public Supplier parse(String value) throws ParseException {
                Supplier supplier = (Supplier)suppliers.get(value);
                if (supplier == null) {
                    throw new SgqBusinessException(I18n._((String)"Prestataire inconnu %s", (Object[])new Object[]{value}));
                }
                return supplier;
            }
        });
        this.newMandatoryColumn("Date d'envoi de l'\u00e9chantillon", "sentDate", (ValueParser)new ValueParser<Date>(){

            public Date parse(String value) throws ParseException {
                return SgqUtils.parseSgqDate(value);
            }
        });
        this.newMandatoryColumn("Date r\u00e9ception de l'\u00e9chantillon", "receiptDate", (ValueParser)new ValueParser<Date>(){

            public Date parse(String value) throws ParseException {
                return SgqUtils.parseSgqDate(value);
            }
        });
    }

    public BatchAnalyze newEmptyInstance() {
        return new BatchAnalyzeImpl();
    }
}

