package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ProductPlaceDAOAbstract<E extends ProductPlace> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)ProductPlace.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.ProductPlace;
    }

    public E findByPresentationCode(PresentationCode v) throws TopiaException {
        E result = findByProperty(ProductPlace.PROPERTY_PRESENTATION_CODE, v);
        return result;
    }

    public List<E> findAllByPresentationCode(PresentationCode v) throws TopiaException {
        List<E> result = findAllByProperty(ProductPlace.PROPERTY_PRESENTATION_CODE, v);
        return result;
    }

    public E findByProduct(Product v) throws TopiaException {
        E result = findByProperty(ProductPlace.PROPERTY_PRODUCT, v);
        return result;
    }

    public List<E> findAllByProduct(Product v) throws TopiaException {
        List<E> result = findAllByProperty(ProductPlace.PROPERTY_PRODUCT, v);
        return result;
    }

    public E findByPlace(Place v) throws TopiaException {
        E result = findByProperty(ProductPlace.PROPERTY_PLACE, v);
        return result;
    }

    public List<E> findAllByPlace(Place v) throws TopiaException {
        List<E> result = findAllByProperty(ProductPlace.PROPERTY_PLACE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //ProductPlaceDAOAbstract<E extends ProductPlace>
