/*
 * #%L
 * SGQ :: Business
 * $Id: InventoryBean.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/InventoryBean.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;

/**
 * Bean d'inport export inventaire.
 * 
 * zone, emplacement, code produit, nom produit, lot, quantité, valeurs relevées
 * 
 * @author echatellier
 */
public class InventoryBean {

    public static final String PROPERTY_PLACE = "place";
    public static final String PROPERTY_BATCH = "batch";
    public static final String PROPERTY_BATCH_MODEL = "batchModel";
    public static final String PROPERTY_PRESENTATION = "presentation";
    public static final String PROPERTY_REAL_QUANTITY = "realQuantity";

    protected Place place;

    protected Batch batch;

    protected BatchModel batchModel;

    protected Presentation presentation;

    protected double realQuantity;

    public Place getPlace() {
        return place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public Batch getBatch() {
        return batch;
    }

    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    public BatchModel getBatchModel() {
        return batchModel;
    }

    public void setBatchModel(BatchModel batchModel) {
        this.batchModel = batchModel;
    }

    public Presentation getPresentation() {
        return presentation;
    }

    public void setPresentation(Presentation presentation) {
        this.presentation = presentation;
    }

    public double getRealQuantity() {
        return realQuantity;
    }

    public void setRealQuantity(double realQuantity) {
        this.realQuantity = realQuantity;
    }
}
