/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.Nonnegative;
import com.helger.base.id.IHasIntID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.state.ISuccessIndicator;
import com.helger.io.file.EFileIOOperation;
import com.helger.io.file.FileIOError;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum EFileIOErrorCode implements ISuccessIndicator,
IHasIntID
{
    NO_ERROR(0),
    OPERATION_FAILED(1),
    SECURITY_ERROR(2),
    SOURCE_DOES_NOT_EXIST(3),
    TARGET_ALREADY_EXISTS(4),
    SOURCE_EQUALS_TARGET(5),
    TARGET_IS_CHILD_OF_SOURCE(6),
    OBJECT_CANNOT_BE_HANDLED(7),
    OBJECT_HAS_NO_PARENT(8),
    SOURCE_NOT_READABLE(9),
    SOURCE_PARENT_NOT_WRITABLE(10),
    TARGET_PARENT_NOT_WRITABLE(11),
    IO_ERROR(12);

    private final int m_nID;

    private EFileIOErrorCode(int n2) {
        this.m_nID = n2;
    }

    @Nonnegative
    public int getID() {
        return this.m_nID;
    }

    public @NonNull FileIOError getAsIOError(@NonNull EFileIOOperation eFileIOOperation, @NonNull File file) {
        return new FileIOError(eFileIOOperation, this, file);
    }

    public @NonNull FileIOError getAsIOError(@NonNull EFileIOOperation eFileIOOperation, @NonNull Path path) {
        return new FileIOError(eFileIOOperation, this, path.toFile());
    }

    public @NonNull FileIOError getAsIOError(@NonNull EFileIOOperation eFileIOOperation, @NonNull File file, @NonNull File file2) {
        if (eFileIOOperation.getParamCount() < 2) {
            throw new IllegalStateException("The operation " + String.valueOf((Object)eFileIOOperation) + " expects only one parameter!");
        }
        return new FileIOError(eFileIOOperation, this, file, file2);
    }

    public @NonNull FileIOError getAsIOError(@NonNull EFileIOOperation eFileIOOperation, @NonNull Path path, @NonNull Path path2) {
        if (eFileIOOperation.getParamCount() < 2) {
            throw new IllegalStateException("The operation " + String.valueOf((Object)eFileIOOperation) + " expects only one parameter!");
        }
        return new FileIOError(eFileIOOperation, this, path.toFile(), path2.toFile());
    }

    public boolean isSuccess() {
        return this == NO_ERROR;
    }

    public static @NonNull FileIOError getSecurityAsIOError(@NonNull EFileIOOperation eFileIOOperation, @NonNull SecurityException securityException) {
        return new FileIOError(eFileIOOperation, SECURITY_ERROR, securityException);
    }

    public static @NonNull FileIOError getAsIOError(@NonNull EFileIOOperation eFileIOOperation, @NonNull IOException iOException) {
        return new FileIOError(eFileIOOperation, IO_ERROR, iOException);
    }

    public static @NonNull FileIOError getAsIOError(@NonNull EFileIOOperation eFileIOOperation, @NonNull UncheckedIOException uncheckedIOException) {
        return new FileIOError(eFileIOOperation, IO_ERROR, uncheckedIOException);
    }

    public static @Nullable EFileIOErrorCode getFromIDOrNull(int n) {
        return (EFileIOErrorCode)EnumHelper.getFromIDOrNull(EFileIOErrorCode.class, (int)n);
    }
}

